package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.entity.npc.NPCWorkModes;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class NPCCloseToCropGoal extends class_1352 {

    protected final NPCEntityImpl maid;
    private final double speed;
    private int cooldown;
    private int moveTime = 0;
    private static final int WORKING_RANGE = 15;
//    private static final Direction SEARCH_DIR = Direction.EAST;
    private static final int MAX_SEARCH_COUNT = 10;
    //1tick搜索的方块数量
    private class_2338 goalPos = null;
    private class_2338 bufferPos = null;

    private boolean hasSeeds;


    private int currRange = 1;
    private int currCount = 0;

    public NPCCloseToCropGoal(NPCEntityImpl maid, double speed) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.maid = maid;
        this.speed = speed;
    }

    @Override
    public boolean method_6264() {
//        if (this.cooldown > 0) {
//            --this.cooldown;
//            return false;
//        }
        if (!EntityTargetUtil.isThisWorkMode(maid, NPCWorkModes.FARM)) {
            return false;
        }
        return true;
    }


    @Override
    public boolean method_6266() {
        return this.method_6264();
    }


    @Override
    public void method_6269() {
    }

    @Override
    public void method_6270() {
        this.maid.method_5942().method_6340();
        this.cooldown = class_1391.method_38848(100);
    }

    @Override
    public void method_6268() {
        hasSeeds = NPCFarmGoal.isMaidHasSeeds(maid);
//        System.out.println("Seed "+ hasSeeds);
        moveTime++;
        if (goalPos == null){
            goalPos = bufferPos;
            bufferPos = getNextGoal();
        }


        if (goalPos ==null
                ||moveTime>500
                || goalPos.method_46558().method_1025(class_243.method_24954(this.maid.getWorkingPos()))>770
                ||this.maid.method_5707(class_243.method_24954(goalPos)) < 2

        ) {
//            System.out.println("Goal "+ (goalPos ==null) +" Time:"+ moveTime );
            this.maid.method_5942().method_6340();
            goalPos = null;
            moveTime = 0;
        } else {
            class_243 look = goalPos.method_46558().method_43206(class_2350.field_11033, 0.5);
            this.maid.method_5988().method_19615(look);
            this.maid.method_5942().method_6337(look.field_1352,look.field_1351,look.field_1350,this.speed);
        }
    }



    //寻路 农田按照平面考虑 应该不会有人在啥阴间的地方让女仆工作吧


    private class_2338 getNextGoal(){
        class_2338 pos = nextPos();

        for (int searchCount = 0;searchCount<MAX_SEARCH_COUNT;searchCount++){
            if (isTargetPos(pos)) {
                return pos;
            }
            pos = nextPos();
        }
        return null;
    }

    private class_2338 nextPos(){
        currCount++;
        if (currCount >= (currRange - 1) * 8) {
            currCount = 0;
            currRange++;
        }
        if (currRange>WORKING_RANGE)currRange = 1;
        return getPos(maid.getWorkingPos(),currRange,currCount);
    }
    private static final  class_2350[] facList = new class_2350[]{class_2350.field_11034,class_2350.field_11043,class_2350.field_11039,class_2350.field_11035};



    private static class_2338 getPos(class_2338 origin,int r,int c){
        if (r == 1) return origin;
        int sideLength = (r-1)*2;
        int side =  c/sideLength;
        int sidePos = c%sideLength;
        class_2350 offDir = facList[side];
        class_2338 offOrigin = origin.method_10079(facList[(side+2)%4],r).method_10079(facList[(side+3)%4],r);
        class_2338 p = offOrigin.method_10079(offDir, sidePos);
        return p;
    }
    protected boolean isTargetPos(class_2338 pos) {
        class_3218 world = method_64451(maid);
        boolean b = (NPCFarmGoal.isCrop(pos, world)
                ||  (hasSeeds&& NPCFarmGoal.isFarmLandTop(pos, world)));
//        System.out.println(pos+"  aaaaa "+b +"  cr "+ NPCFarmGoal.isCrop(pos, world)
//        +" farm "+NPCFarmGoal.isFarmLandTop(pos, world));
        return b;
    }
//    private BlockPos offset(BlockPos pos,Direction dir){
//        BlockPos offset3 = pos.offset(dir, 3);
//        if (isInRange(offset3)){
//            return offset3;
//        }
//        BlockPos offset2 = pos.offset(dir, 2);
//        return isInRange(offset2)?offset2:null;
//    }
//    private boolean isInRange(BlockPos pos){
//        BlockPos workingPos = maid.getWorkingPos();
//        return pos.getX()>=workingPos.getX()-15&&pos.getX()<=workingPos.getX()+15
//                &&pos.getZ()>=workingPos.getZ()-15&&pos.getZ()<=workingPos.getZ()+15;
//    }
//    //重置位置
//    public void resetPos(){
//        offDir = SEARCH_DIR;
//        searchPos = maid.getWorkingPos().offset(offDir.rotateCounterclockwise(Direction.Axis.Y),WORKING_RANGE)
//                .offset(offDir.getOpposite(),15);
//
//    }


}

