package cc.thonly.reverie_dreams.entity.holder;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Pose;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;


public class SimpleMovementRotatingHolder<T extends class_1309 & AnimatedEntity> extends LivingEntityHolder<T> {
    private float lastYaw = 0.f;
    private float lastPitch = 0.f;

    public SimpleMovementRotatingHolder(T parent, Model model) {
        super(parent, model);
    }

    @Override
    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        var translation = new Vector3f(0, -0.1f, 0);
        Matrix4f matrix4f = new Matrix4f().translate(translation);

        Vector3f movement = parent.method_60478().method_46409();
        if (movement.lengthSquared() > 0.0001f) {
            movement.normalize();
            float movementYaw = (float) Math.atan2(-movement.x, movement.z);
            float movementPitch = (float) Math.asin(movement.y);

            lastPitch = class_3532.method_61345(0.5f, movementPitch, lastPitch);
            lastYaw = class_3532.method_61345(0.5f, movementYaw, lastYaw);

            matrix4f
                    .rotateLocalZ(0)
                    .rotateLocalX(lastPitch)
                    .rotateLocalY(-lastYaw + class_3532.field_29844);

            display.element().setTransformation(serverPlayer, matrix4f);
            display.element().startInterpolationIfDirty(serverPlayer);
        }
    }

    @Override
    public void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        if (pose == null) {
            this.applyPose(serverPlayer, display.getLastPose(serverPlayer), display);
        } else {
            this.applyPose(serverPlayer, pose, display);
        }
    }

}
