package cc.thonly.reverie_dreams.entity.misc;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.damage.DanmakuDamageType;
import cc.thonly.reverie_dreams.entity.FriendlyFaction;
import cc.thonly.reverie_dreams.entity.ModEntities;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Method;
import java.util.List;


@Setter
@Getter
@ToString
public class DanmakuEntity extends class_1665 {
    public static final class_2940<Float> ROLL = class_2945.method_12791(DanmakuEntity.class, class_2943.field_13320);
    public static final int MAX_FLIGHT_TICK = 20 * 20;
    protected class_1792 danmakuItem;
    protected class_1799 itemStack = class_1802.field_8543.method_7854();
    protected Float scale;
    protected Boolean tile = false;
    protected DanmakuDamageType danmakuDamageType;
    protected Float acceleration = 0f;
    protected OnHitFactory onHitEffect = (livingEntity, damage) -> {

    };
    private final float setupPitch;
    private final float setupYaw;
    private double damage;

    public int flyAge = 0;
    protected int fluidAge = 0;
    protected int fightTick = 0;
    protected int particleTick = 0;

    public DanmakuEntity(@Nullable class_1297 livingEntity, class_3218 world, Double x, Double y, Double z, class_1799 stack, Float pitch, Float yaw, Float speed, Float acceleration, Float divergence, Float offsetDist) {
        super(ModEntities.DANMAKU_ENTITY_TYPE,
                x,
                y + (livingEntity != null ? livingEntity.method_5751() : 0),
                z,
                world,
                stack.method_7972(),
                stack.method_7972());
        this.setupPitch = pitch;
        this.setupYaw = yaw;
        double offsetX = -Math.sin(Math.toRadians(yaw)) * offsetDist;
        double offsetZ = Math.cos(Math.toRadians(yaw)) * offsetDist;

        double newX = x + offsetX;
        double newY = y + (livingEntity != null ? livingEntity.method_5751() : 0);
        double newZ = z + offsetZ;
        this.method_23327(newX, newY, newZ);
        this.acceleration = acceleration;

        this.method_7432(livingEntity);
        if (livingEntity != null) {
            this.method_24919(livingEntity, pitch, yaw, 0.0F, speed, divergence);
        } else {
            this.method_24919(this, pitch, yaw, 0.0F, speed, divergence);
        }
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.field_7572 = class_1666.field_7594;
        this.method_7438(stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE, 1.0f) * 1.5);
        this.setScale(stack.method_58695(ModDataComponentTypes.Danmaku.SCALE, 1.0f) * 0.65F);
        String type = stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE_TYPE, Touhou.id("generic").toString());
        this.setTile(stack.method_58695(ModDataComponentTypes.Danmaku.TILE, false));
        this.setDanmakuDamageType(RegistryManager.DANMAKU_DAMAGE_TYPE.method_63535(class_2960.method_60654(type)));
        this.setCustomPierceLevel((byte) 1);
        this.setItemStack(stack.method_7972());
        this.setDanmakuItem(stack.method_7909());
        this.method_5875(true);
    }

    public DanmakuEntity(class_1299<DanmakuEntity> danmakuEntityEntityType, class_1937 world) {
        super(danmakuEntityEntityType, world);
        this.setDanmakuItem(null);
        this.scale = 1f;
        this.setupPitch = 0;
        this.setupYaw = 0;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ROLL, 0f);
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.itemStack.method_7960()) {
            view.method_71468("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC, this.itemStack.method_7972());
        }
        view.method_71472("IsTile", this.tile);
        class_2960 danmakuDamageTypeId = RegistryManager.DANMAKU_DAMAGE_TYPE.method_10221(this.danmakuDamageType);
        if (danmakuDamageTypeId != null) {
            view.method_71469("DamageType", danmakuDamageTypeId.toString());
        }
        view.method_71465("FlyAge", this.flyAge);
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.itemStack = view.method_71426("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC).orElse(class_1799.field_8037);
        this.tile = view.method_71433("IsTile", true);
        this.danmakuDamageType = RegistryManager.DANMAKU_DAMAGE_TYPE.method_63535(class_2960.method_60654(view.method_71428("DamageType", Touhou.id("generic").toString())));

        this.flyAge = view.method_71424("FlyAge", 0);

    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.fightTick++;
        this.particleTick++;
        if (!this.method_65059()) {
            this.field_6011.method_12778(ROLL, (float) (this.field_6011.method_12789(ROLL) - class_3532.field_29847 * this.method_18798().method_1027() * 15) % class_3532.field_29846);
        }
        this.method_36457(this.setupPitch);
        this.method_36456(this.setupYaw);
        if (this.particleTick > 2) {
            class_1937 world = this.method_37908();
            if (!world.method_8608() && world instanceof class_3218 serverWorld) {
                serverWorld.method_65096(
                        class_2398.field_28013,
                        this.method_19538().field_1352,
                        this.method_19538().field_1351,
                        this.method_19538().field_1350,
                        1,
                        0,
                        0,
                        0,
                        0.1
                );
            }
            this.particleTick = 0;
        }

        if (this.method_5799()) {
//            this.setVelocity(this.getVelocity().multiply(0.8));
            this.fluidAge++;
            if (this.fluidAge > 80) {
                this.method_31472();
            }
        }

        if (this.fightTick > MAX_FLIGHT_TICK) {
            this.method_31472();
        }
    }

    @Override
    protected void method_24920(class_3965 blockHitResult) {
        this.method_33574(blockHitResult.method_17784());
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2680 block = this.method_37908().method_8320(blockHitResult.method_17777());
            blockHitParticles(this.method_19538(), block, this.method_37908(), this.getDamage() * this.method_18798().method_1033());
            class_3414 soundEvent = block.method_26231().method_10596();
            method_5803(false);
            method_5783(soundEvent, 0.2F, 1.0F);
            method_5803(true);
        }
        this.method_33572(true);
        super.method_24920(blockHitResult);
        this.method_33572(false);
        this.method_31472();
    }

    protected boolean canDamage(class_1297 entity, class_1297 owner) {
        if (entity instanceof BypassHitEntity) {
            return false;
        }
        if (owner == entity) {
            return false;
        }
        if (owner instanceof FriendlyFaction ownerFaction &&
                entity instanceof FriendlyFaction entityFaction) {
            return !ownerFaction.getFactionId().equals(entityFaction.getFactionId());
        }
        return true;
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        if (!this.canDamage(entity, owner)) {
            return;
        }

        if (entity instanceof class_1657 player) {
            if (player.method_6039()) {
                boolean isInAttackRange = false;
                class_1799 activeItem = player.method_6030();
                if (!activeItem.method_7960()) {
                    class_10707 blocksAttacksComponent = activeItem.method_58694(class_9334.field_56396);
                    if (blocksAttacksComponent != null) {
                        List<class_10707.class_10708> damageReductions = blocksAttacksComponent.comp_3588();
                        for (class_10707.class_10708 damageReduction : damageReductions) {
                            float blockingAngle = damageReduction.comp_3638();

                            // ① 使用 EyePos，避免高度误差
                            class_243 toProjectile = this.method_19538().method_1020(player.method_33571()).method_1029();

                            // ② 只取水平向量，忽略 Y
                            class_243 playerLook = player.method_5828(1.0F);
                            class_243 look2D = new class_243(playerLook.field_1352, 0, playerLook.field_1350).method_1029();
                            class_243 toProj2D = new class_243(toProjectile.field_1352, 0, toProjectile.field_1350).method_1029();

                            // ③ 点积求角度，clamp 防止 NaN
                            double dot = class_3532.method_15350(look2D.method_1026(toProj2D), -1.0, 1.0);
                            double angle = Math.toDegrees(Math.acos(dot));

                            // ④ 给一个小容错（比如 +5°）
                            if (angle <= (blockingAngle / 2.0F) + 5.0F) {
                                isInAttackRange = true;
                                break; // 找到一个满足条件的就可以退出循环了
                            }
                        }
                    }
                    if (isInAttackRange) {
                        activeItem.method_61653(1, player);
                        this.method_31472(); // 拦截并移除投射物
                        return;
                    }
                }
            }

        }

        this.method_33574(entityHitResult.method_17784());
        this.method_5803(false);
        this.method_5803(true);

        if (entityHitResult.method_17782() != null) {
            this.method_7438(this.getDamage());
            this.entityHitParticles(entityHitResult.method_17782(), this.getDamage() * this.method_18798().method_1033());
        }

        this.hitDamage(entityHitResult, this.method_37908());
        this.method_31472();
    }

    protected void hitDamage(class_3966 entityHitResult, class_1937 world) {
        if (world instanceof class_3218 serverWorld) {
            class_1297 target = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();

            if (target instanceof class_1309 livingTarget && this.method_24921() != entityHitResult.method_17782()) {
                class_1282 damageSource;

                if (owner instanceof class_1309 attacker) {
                    damageSource = world.method_48963().method_48800(this, attacker);
                } else {
                    damageSource = this.danmakuDamageType.mapToSource(world.method_48963());
                }

                float damageAmount = (float) this.getDamage();
                livingTarget.method_64397(serverWorld, damageSource, damageAmount);
                livingTarget.method_5684(false);
                livingTarget.field_6253 = 0;
                this.onHitEffect.damage(livingTarget, this.getDamage());
            }
        }
    }

    protected void entityHitParticles(class_1297 livingEntity, double damage) {
        if (livingEntity.method_37908() instanceof class_3218 world) {
            class_243 pos = livingEntity.method_19538();
            int particleCount = (int) damage * 4;
            double radius = livingEntity.method_17681() / 2 + 0.5;
            double heightOffset = livingEntity.method_17682();

            for (int i = 0; i < particleCount; i++) {
                double angle = (2 * Math.PI / particleCount) * i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);

                class_2392 itemStackParticleEffect = new class_2392(class_2398.field_11218, this.method_57314());
                world.method_65096(
                        itemStackParticleEffect,
                        pos.field_1352,
                        pos.field_1351,
                        pos.field_1350,
                        1,
                        xOffset,
                        (heightOffset / particleCount) * i,
                        zOffset,
                        0.25
                );
            }
        }
    }

    protected void blockHitParticles(class_243 pos, class_2680 blockState, class_1937 worldTemp, double damage) {
        if (worldTemp instanceof class_3218 world) {
            int particleCount = (int) damage * 4;
            double radius = 1;
            double heightOffset = 1;


            for (int i = 0; i < particleCount; i++) {
                double angle = (2 * Math.PI / particleCount) * i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);

                class_2388 blockStateParticleEffect = new class_2388(class_2398.field_11217, blockState);
                world.method_65096(
                        blockStateParticleEffect,
                        pos.field_1352,
                        pos.field_1351,
                        pos.field_1350,
                        1,
                        xOffset,
                        (heightOffset / particleCount) * i,
                        zOffset,
                        0.25
                );
            }
        }
    }


    public void setCustomPierceLevel(byte level) {
        if (!tryInvokeMethod(class_1665.class, "setPierceLevel", byte.class, level)) {
            tryInvokeMethod(class_1665.class, "method_7451", byte.class, level);
        }
    }

    private boolean tryInvokeMethod(Class<?> targetClass, String methodName, Class<?> paramType, Object paramValue) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke(this, paramValue);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected class_1799 method_57314() {
        if (this.danmakuItem != null && !this.danmakuItem.method_7854().method_7960()) {
            return this.danmakuItem.method_7854();
        } else {
            return new class_1799(ModItems.ICON);
        }
    }

    public interface OnHitFactory {
        void damage(class_1309 livingEntity, double damage);
    }

}
