package cc.thonly.reverie_dreams.entity.npc;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.entity.skin.NPCSkin;
import cc.thonly.reverie_dreams.item.base.SpawnEggItem;
import cc.thonly.reverie_dreams.registry.*;
import cc.thonly.reverie_dreams.util.IdentifierGetter;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Setter
@Getter
public class NPCRole implements CodecStep<NPCRole>, OwnerBinding<NPCRole>, BuiltinObject, Translatable {
    public static final Codec<NPCRole> CODEC = Codec.unit(NPCRole::new);
    public static final List<class_1792> NPC_SPAWN_EGG_ITEM_LIST = new LinkedList<>();

    private class_2960 id;
    private Property property;
    // 构建后属性
    private class_1299<AbstractNPCEntity> entityType;
    private class_1792 spawnEgg;
    private Class<? extends NPCEntityImpl> clazz;
    private boolean hasBuilt = false;

    private IntrinsicalRegister<NPCRole> owner;;

    private NPCRole() {
    }

    public NPCRole(class_2960 id, Property property) {
        this(id, property, NPCRoleEntityImpl.class);
    }

    public NPCRole(class_2960 id, NPCSkin skin) {
        this(id, skin.get(), NPCRoleEntityImpl.class);
    }

    public NPCRole(class_2960 id, Property property, Class<NPCRoleEntityImpl> clazz) {
        this.id = id;
        this.property = property;
        this.clazz = clazz;
    }

    public boolean isPresent() {
        return this.entityType != null;
    }

    public boolean isEmpty() {
        return this.entityType == null;
    }

    public class_1299<AbstractNPCEntity> get() {
        return this.entityType;
    }

    public class_1792 getEgg() {
        return this.spawnEgg;
    }

    @Override
    public String translateKey() {
        return this.entityType.method_5882();
    }

    public NPCRole build() {
        if (hasBuilt) {
            return this;
        }
        try {
            class_1299<AbstractNPCEntity> entityType = registerEntity(this.id,
                    class_1299.class_1300.<AbstractNPCEntity>method_5903(
                                    (type, world) -> {
                                        try {
                                            return this.clazz.getConstructor(class_1299.class, class_1937.class, Property.class)
                                                    .newInstance(type, world, property);
                                        } catch (Exception e) {
                                            log.error("Failed to instantiate NPCEntityImpl for type {}, {}", id, e);
                                            return null;
                                        }
                                    },
                                    class_1311.field_17715)
                            .method_5905(of(this.id)));
            FabricDefaultAttributeRegistry.register(entityType, NPCEntityImpl.createAttributes());
            class_2960 spawnEggId = class_2960.method_60655(this.id.method_12836(), this.id.method_12832() + "_spawn_egg");
            class_1792 spawnEgg = registerNPCSpawnEggItem(new SpawnEggItem(spawnEggId, entityType, new class_1792.class_1793().modelId(Touhou.id("spawn_egg"))));
            this.entityType = entityType;
            this.spawnEgg = spawnEgg;
            this.hasBuilt = true;
        } catch (Exception e) {
            log.error("Can't register role entity type {}", this.id.toString());
        }
        return this;
    }

    @Override
    public Codec<NPCRole> getCodec() {
        return CODEC;
    }

    protected static <T extends class_1297> class_1299<T> registerEntity(class_2960 id, class_1299<T> entityType) {
        class_1299<T> entityTypeRef = class_2378.method_10230(class_7923.field_41177, id, entityType);
        PolymerEntityUtils.registerType(entityTypeRef);
        return entityTypeRef;
    }

    protected static class_1792 registerNPCSpawnEggItem(IdentifierGetter item) {
        class_2378.method_10230(class_7923.field_41178, item.getIdentifier(), (class_1792) item);
        NPC_SPAWN_EGG_ITEM_LIST.add((class_1792) item);
        return (class_1792) item;
    }

    private static class_5321<class_1299<?>> of(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41266, id);
    }
}
