package cc.thonly.reverie_dreams.entity.npc;

import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.entity.ai.goal.*;
import cc.thonly.reverie_dreams.entity.ai.goal.work.*;
import cc.thonly.reverie_dreams.interfaces.IExperienceOrbEntity;
import com.mojang.authlib.properties.Property;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1386;
import net.minecraft.class_1399;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9817;
import net.minecraft.entity.*;
import net.minecraft.entity.ai.goal.*;
import java.util.List;

@Getter
@Setter
public class NPCRoleEntityImpl extends NPCEntityImpl implements class_9817 {

    public NPCRoleEntityImpl(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public NPCRoleEntityImpl(class_1299<? extends class_1321> entityType, class_1937 world, Property skin) {
        super(entityType, world, skin);
    }

    @Override
    protected void method_5959() {
        super.method_5959();

        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1386(this));
        this.field_6201.method_6277(1, new NPCEatFoodDispalyGoal(this, 1, 15, 1));
        this.field_6201.method_6277(2, new EatGoal(this));
        this.field_6201.method_6277(3, new SleepAtNightGoal(this, 1.0));

        this.field_6201.method_6277(4, new NPCTemptGoal(this, 1.2, stack -> stack.method_31573(ModTags.ItemTypeTag.ROLE_TAME_FOOD), false));
        //        this.goalSelector.add(4, this.bowAttackGoal);
        //        this.goalSelector.add(4, this.meleeAttackGoal);

        this.field_6201.method_6277(6, new NPCFollowOwnerGoal(this, 1.0, 2.0f, 10.0f));
        this.field_6201.method_6277(7, new class_1341(this, 1.0));
        this.field_6201.method_6277(8, new NPCWanderAroundFarGoal(this, 1.0));

        this.field_6201.method_6277(10, new NPCLookAroundGoal(this));
        this.field_6201.method_6277(10, new NPCLookAtEntityGoal(this, class_1657.class, 8.0f, 0.02f, true));
        this.field_6201.method_6277(10, new NPCLookAtEntityGoal(this, NPCEntityImpl.class, 8.0f, 0.02f, true));

        this.field_6185.method_6277(1, new NPCTrackOwnerAttackerGoal(this));
        this.field_6185.method_6277(1, new NPCCleanMonsterGoal(this));
        this.field_6185.method_6277(1, new NPCBreedGoal(this));
        this.field_6185.method_6277(1, new NPCSheepShearGoal(this));
        this.field_6185.method_6277(2, new NPCAttackWithOwnerGoal(this));
        this.field_6185.method_6277(3, new class_1399(this).method_6318());

        this.field_6201.method_6277(1, new NPCOpenDoorGoal(this));
        this.field_6201.method_6277(1, new NPCOpenSilverChestGoal(this));
        this.field_6201.method_6277(1, new NPCSmeltGoal(this));
        this.field_6201.method_6277(1, new NPCChestClassificationGoal(this));
        this.field_6201.method_6277(1, new NPCFarmGoal(this));
        this.field_6201.method_6277(1, new NPCAutoPickItemGoal(this));
        this.field_6201.method_6277(2, new NPCCloseToCropGoal(this, 1));


        this.method_5942().method_70687(true);
        this.method_5942().method_6354(true);
    }

    @Override
    public void method_5773() {
        class_1937 world = this.method_37908();
        if (!world.field_9236 && world.method_8530()) {
            this.method_18400();
        }
        this.attractNearbyExperienceOrbs();
        super.method_5773();
    }

    @Override
    protected void method_16080(class_3218 world, class_1282 damageSource) {
//        super.drop(world, damageSource);
    }

    public void attractNearbyExperienceOrbs() {
        if (this.method_37908().field_9236) return; // 只在服务端处理

        double radius = 7.0;
        List<class_1303> orbs = this.method_37908().method_8390(
                class_1303.class,
                this.method_5829().method_1014(radius),
                class_1297::method_5805
        );

        for (class_1303 orb : orbs) {
            ((IExperienceOrbEntity) (Object) orb).setNPCTarget(this);
        }
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309 livingEntity &&
                livingEntity.method_5998(class_1268.field_5808).method_7960() &&
                livingEntity.method_5998(class_1268.field_5810).method_7960() &&
                livingEntity.method_5715() && this.method_6171(livingEntity)
        ) {
            this.method_5980(null);
            this.method_6015(null);
            return false;
        }
        return super.method_64397(world, source, amount);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1937 world = this.method_37908();
        if (world.field_9236 || !(world instanceof class_3218 serverWorld) || !(player instanceof class_3222 serverPlayerEntity)) {
            return super.method_5992(player, hand);
        }
        return NPCRoleInteractionEvents.emit(serverWorld, serverPlayerEntity, hand, this);
    }

    @Override
    public KeepInventoryTypes getKeepInventoryType() {
        return KeepInventoryTypes.ARCHIVED;
    }

    @Override
    public boolean method_5931() {
        return true;
    }

    @Override
    public Boolean canFeed() {
        return true;
    }

    @Override
    public Boolean canDamageEquipment() {
        return true;
    }

    @Override
    public Boolean consumeHunger() {
        return true;
    }
}
