package cc.thonly.reverie_dreams.entity.skin;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.registry.*;
import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.Optional;


@Slf4j
public class NPCSkin implements CodecStep<NPCSkin>, OwnerBinding<NPCSkin>, BuiltinObject, Translatable {
    /**
     * 预升级 1.21.9 所用代码
     **/
    private static final Map<class_2960, MannequinInfo> INFO = new Object2ObjectLinkedOpenHashMap<>();

    private record MannequinInfo(class_2960 texture, Optional<class_2960> capeTexture,
                                 Optional<class_2960> elytraTexture, PlayerSkinType model) {

    }

    enum PlayerSkinType {
        SLIM("slim", "slim"),
        WIDE("wide", "default");
        private final String name;
        private final String modelMetadata;

        private PlayerSkinType(final String name, final String modelMetadata) {
            this.name = name;
            this.modelMetadata = modelMetadata;
        }
    }
    private static final Gson GSON = new Gson();

    public static final Codec<NPCSkin> UNIT_CODEC = Codec.unit(NPCSkin::new);
    public static final Codec<NPCSkin> CODEC = null;
    @Setter
    @Getter
    private class_2960 id;
    private String value;
    private String signature;
    private Property instance;
    @Setter
    @Getter
    private NPCSkinConfig config;
    @Getter
    @Setter
    private IntrinsicalRegister<NPCSkin> owner;

    private NPCSkin() {
    }

    public NPCSkin(class_2960 id, String value, String signature) {
        this.id = id;
        this.value = value;
        this.signature = signature;
        this.valid();
    }

    @Override
    public String translateKey() {
        Property property = this.get();
        return property.name() + "|" + this.id;
    }

    public Property get() {
        if (this.instance == null) {
            this.instance = texture(this.value, this.signature);
        }
        return this.instance;
    }

    private void valid() {
        Property property = this.get();
        try {
            class_2960 fileId = Touhou.id("entity/player/%s".formatted(this.id.method_12832()));

        } catch (Exception err) {
            log.error("Can't parse role code", err);
        }
    }

    private static Property texture(String value, String signature) {
        return new Property("textures", value, signature);
    }

    @Override
    public Codec<NPCSkin> getCodec() {
        return UNIT_CODEC;
    }
}
