package cc.thonly.reverie_dreams.entity.skin;

import cc.thonly.reverie_dreams.registry.CodecStep;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import java.util.Optional;

@Getter
public class NPCSkinConfig implements CodecStep<NPCSkinConfig>, OwnerBinding<NPCSkinConfig> {
    public static final Codec<NPCSkinConfig> CODEC = RecordCodecBuilder.create(x -> x.group(
            ModelType.CODEC.fieldOf("type").forGetter(NPCSkinConfig::getType),
            class_2960.field_25139.optionalFieldOf("cape").forGetter(NPCSkinConfig::getCapeTexture),
            class_2960.field_25139.optionalFieldOf("elytra").forGetter(NPCSkinConfig::getElytraTexture)
    ).apply(x, NPCSkinConfig::new));

    private final ModelType type;
    private final Optional<class_2960> capeTexture;
    private final Optional<class_2960> elytraTexture;
    @Setter
    private IntrinsicalRegister<NPCSkinConfig> owner;

    public NPCSkinConfig(ModelType type, Optional<class_2960> capeTexture, Optional<class_2960> elytraTexture) {
        this.type = type;
        this.capeTexture = capeTexture;
        this.elytraTexture = elytraTexture;
    }

    @Override
    public Codec<NPCSkinConfig> getCodec() {
        return CODEC;
    }

    public enum ModelType implements class_3542 {
        SLIM("slim"),
        WIDE("wide");
        public static final Codec<ModelType> CODEC = class_3542.method_28140(ModelType::values);
        private final String name;

        private ModelType(final String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return this.name;
        }
    }
}
