package cc.thonly.reverie_dreams.entity.skin;

import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

@Slf4j
public class NPCSkinConfigs {

    public static void bootstrap(IntrinsicalRegister<NPCSkinConfig> registry) {

    }

    public static void reload(class_3300 manager) {
        for (NPCSkin skin : RegistryManager.ROLE_SKIN) {
            skin.setConfig(new NPCSkinConfig(NPCSkinConfig.ModelType.SLIM, Optional.empty(), Optional.empty()));
        }
        Map<class_2960, class_3298> resources = manager.method_14488("skin_config", id -> id.method_12832().endsWith(".json"));
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 resourceId = entry.getKey();
            class_2960 key = class_2960.method_60655(resourceId.method_12836(), resourceId.method_12832()
                    .replace("skin_config/", "")
                    .replace(".json", "")
            );
            class_3298 resource = entry.getValue();
            NPCSkin skin = RegistryManager.ROLE_SKIN.method_63535(key);
            if (skin == null) {
                log.warn("Unknown skin id: {}", resourceId);
                continue;
            }
            try (InputStream stream = resource.method_14482()) {
                JsonElement json = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, json);

                DataResult<NPCSkinConfig> result = NPCSkinConfig.CODEC.parse(input);
                result.resultOrPartial(error -> log.warn("Failed to parse Skin Config for {}: {}", resourceId, error))
                        .ifPresent(data -> {
                            skin.setConfig(data);
                            RegistryManager.register(RegistryManager.SKIN_CONFIG, key, data);
                        });
            } catch (IOException e) {
                log.error("Failed to load Skin Config {}: {}", resourceId, e.getMessage(), e);
            }

        }
    }
}
