package cc.thonly.reverie_dreams.entity.villager;

import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import eu.pb4.sgui.api.gui.MerchantGui;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1364;
import net.minecraft.class_1370;
import net.minecraft.class_1374;
import net.minecraft.class_1390;
import net.minecraft.class_1394;
import net.minecraft.class_1564;
import net.minecraft.class_1581;
import net.minecraft.class_1604;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3850;
import net.minecraft.class_3989;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5136;
import net.minecraft.entity.ai.goal.*;
import net.minecraft.entity.mob.*;
import net.minecraft.server.MinecraftServer;
import java.util.*;

@Slf4j
@Getter
public abstract class AbstractSellerEntity extends class_3989 {
    public static final int MAX_LEVEL = 5;
    public static final int[] EXPS = {50, 100, 150, 200, 250};
    private static final Gson GSON = new Gson();
    private static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of(class_4140.field_26389);
    protected final Set<SellerGui> sessions = new HashSet<>();
    protected class_3850 prev;
    protected SellInfo sellInfo = new SellInfo(new Object2ObjectOpenHashMap<>());
    protected int level = 0;
    protected int exp = 0;

    public AbstractSellerEntity(class_1299<? extends class_3989> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5942().method_70687(true);
        this.method_5942().method_6354(true);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
//        this.goalSelector.add(0, new HoldInHandsGoal<WanderingTraderEntity>(this, PotionContentsComponent.createStack(Items.POTION, Potions.INVISIBILITY), SoundEvents.ENTITY_WANDERING_TRADER_DISAPPEARED, wanderingTrader -> this.getWorld().isNight() && !wanderingTrader.isInvisible()));
//        this.goalSelector.add(0, new HoldInHandsGoal<WanderingTraderEntity>(this, new ItemStack(Items.MILK_BUCKET), SoundEvents.ENTITY_WANDERING_TRADER_REAPPEARED, wanderingTrader -> this.getWorld().isDay() && wanderingTrader.isInvisible()));
        this.field_6201.method_6277(1, new class_1390(this));
        this.field_6201.method_6277(1, new class_1338<class_1642>(this, class_1642.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_1564>(this, class_1564.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_1632>(this, class_1632.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_1634>(this, class_1634.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_1604>(this, class_1604.class, 15.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_1581>(this, class_1581.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1338<class_5136>(this, class_5136.class, 10.0f, 0.5, 0.5));
        this.field_6201.method_6277(1, new class_1374(this, 0.5));
        this.field_6201.method_6277(1, new class_1364(this));
        this.field_6201.method_6277(2, new class_3994(this, 2.0, 0.35));
        this.field_6201.method_6277(4, new class_1370(this, 0.35));
        this.field_6201.method_6277(8, new class_1394(this, 0.35));
        this.field_6201.method_6277(9, new class_1358(this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, new class_1361(this, class_1308.class, 8.0f));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.level > MAX_LEVEL) {
            this.level = MAX_LEVEL;
        }
    }

    public void trade(ItemStackWrapper wrapper) {
        class_1937 world = this.method_37908();
        Random random = new Random();
        this.exp += random.nextInt(9, 25);
        this.method_56078(class_3417.field_14627);
        this.sellInfo.sell(this.getVillagerSeed(), wrapper);
        this.tryLevelUp();
    }

    public void tryLevelUp() {
        while (this.level < MAX_LEVEL && this.exp >= EXPS[this.level]) {
            this.exp -= EXPS[this.level];
            this.level++;

            this.method_56078(class_3417.field_14709);
        }

        if (this.level >= MAX_LEVEL) {
            this.level = MAX_LEVEL;
            this.exp = Math.min(this.exp, EXPS[MAX_LEVEL - 1]);
        }
    }

    public abstract class_3850 getModifyVillagerData(MinecraftServer server);

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1937 baseWorld = player.method_37908();
        class_1799 stack = player.method_5998(hand);
        if (!baseWorld.method_8608() && baseWorld instanceof class_3218 world) {
            if (stack.method_7909() instanceof class_1821 && player.method_5715() && this.canReset()) {
                boolean canceled = this.cancel();
                if (canceled && !player.method_56992()) {
                    stack.method_61653(1, player);
                }
                player.method_6104(hand);
                return class_1269.field_52422;
            }
            if (this.sessions.isEmpty()) {
                class_3222 serverPlayer = (class_3222) player;

                this.method_5702(class_2183.class_2184.field_9851, player.method_19538().method_1031(0, 1, 0));
                this.method_5942().method_6340();

                SellerGui sellerGui = new SellerGui(serverPlayer, this);
                sellerGui.open();
                player.method_6104(hand);
                return class_1269.field_52422;
            }
        }
        return class_1269.field_5812;
    }

    public static class_5132.class_5133 method_26827() {
        return class_1308.method_26828();
    }

    @Override
    public void method_6007() {
        if (!this.method_37908().method_8608() && !this.sessions.isEmpty()) {
            return;
        }
        super.method_6007();
    }

    public boolean cancel() {
        class_1937 world = this.method_37908();
        if (this.prev != null) {
            class_1646 villager = new class_1646(class_1299.field_6077, this.method_37908());
            villager.method_7195(this.prev);
            villager.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
            this.method_56078(class_3417.field_17481);
            this.method_31472();
            world.method_8649(villager);
            return true;
        }
        return false;
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        Optional<String> prevVillagerData = view.method_71441("PrevVillagerData");
        if (prevVillagerData.isPresent()) {
            String jsonString = prevVillagerData.get();
            JsonElement element = JsonParser.parseString(jsonString);
            Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, element);
            DataResult<class_3850> parse = class_3850.field_24669.parse(input);
            Optional<class_3850> result = parse.result();
            result.ifPresent((data) -> this.prev = data);
        }
        this.level = view.method_71424("Level",0);
        Optional<String> sellInfoData = view.method_71441("SellInfoData");
        if (sellInfoData.isPresent()) {
            String jsonString = sellInfoData.get();
            JsonElement element = JsonParser.parseString(jsonString);
            Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, element);
            DataResult<SellInfo> parse = SellInfo.CODEC.parse(input);
            Optional<SellInfo> result = parse.result();
            result.ifPresent((data) -> this.sellInfo = data);
        }
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (this.prev != null) {
            DataResult<JsonElement> dataResult = class_3850.field_24669.encodeStart(JsonOps.INSTANCE, this.prev);
            Optional<JsonElement> result = dataResult.result();
            if (result.isPresent()) {
                JsonElement element = result.get();
                view.method_71469("PrevVillagerData", GSON.toJson(element));
            }
        }
        view.method_71465("Level", this.level);
        if (this.sellInfo != null) {
            DataResult<JsonElement> dataResult = SellInfo.CODEC.encodeStart(JsonOps.INSTANCE, this.sellInfo);
            Optional<JsonElement> result = dataResult.result();
            if (result.isPresent()) {
                JsonElement element = result.get();
                view.method_71469("SellInfoData", GSON.toJson(element));
            }
        }
    }

    public abstract List<class_1914> getVillagerOffers();

    public long getVillagerSeed() {
        UUID uuid = this.method_5667();
        class_1937 world = this.method_37908();
        long day = world.method_8532() / 24000L;
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        return mostSigBits + leastSigBits + day;
    }

    @Getter
    public static class SellerGui extends MerchantGui {
        private final AbstractSellerEntity self;

        public SellerGui(class_3222 player, AbstractSellerEntity self) {
            super(player, false);
            this.self = self;
            this.init();
        }

        public void init() {
            this.setTitle(this.self.method_5477());
            List<class_1914> villagerOffers = this.self.getVillagerOffers();
            for (class_1914 offer : villagerOffers) {
                this.addTrade(offer);
            }
            if (villagerOffers.isEmpty()) {
                this.self.method_31472();
                this.close();
            }
        }

        @Override
        public boolean onTrade(class_1914 offer) {
            class_1914 copied = offer.method_53881();
            this.self.trade(ItemStackWrapper.of(copied.method_18019()));
            this.self.method_8262(copied);
            return super.onTrade(offer);
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.self.getSessions().add(this);
        }

        @Override
        public void onClose() {
            super.onClose();
            this.self.getSessions().remove(this);
        }
    }

    public abstract boolean canReset();
}
