package cc.thonly.reverie_dreams.gui.recipe.block;

import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.block.entity.GensokyoAltarBlockEntity;
import cc.thonly.reverie_dreams.item.ModGuiItems;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class GensokyoAltarGui extends SimpleGui {
    public static final String[][] GRID = {
            {"X", "X", "I", "X", "I", "X", "I", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "I", "X", "E", "X", "I", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "I", "X", "I", "X", "I", "X", "X"},
    };
    class_3222 player;
    GensokyoAltarBlockEntity blockEntity;
    class_2680 state;
    class_2338 pos;

    public GensokyoAltarGui(class_3222 player, class_2680 state, class_1937 world, class_2338 pos) {
        super(class_3917.field_18667, player, false);
        this.player = player;
        this.state = state;
        this.blockEntity = (GensokyoAltarBlockEntity) world.method_8321(pos);
        this.pos = pos;
        this.init();
    }

    public void init() {
        this.setTitle(class_2561.method_43471(ModBlocks.GENSOKYO_ALTAR.method_63499()));
        int invSlot = 0;
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                String pos = GRID[row][col];
                int index = row * 9 + col;
                if (pos.equalsIgnoreCase("X")) {
                    this.setSlot(index, new GuiElementBuilder()
                            .setItem(ModGuiItems.EMPTY_SLOT));
                    continue;
                }
                if (pos.equalsIgnoreCase("I")) {
                    this.setSlotRedirect(index, new class_1735(blockEntity.getInventory(), invSlot, 0, 0));
                    invSlot++;
                    continue;
                }
                if (pos.equalsIgnoreCase("E")) {
                    this.setSlotRedirect(index, new class_1735(blockEntity.getInventory(), 8, 0, 0));
                }
            }
        }
    }

    @Override
    public void onTick() {
        super.onTick();
        if (blockEntity == null) return;
        if (blockEntity.method_10997() != null && blockEntity.method_10997().method_8320(blockEntity.method_11016()).method_26204() != ModBlocks.GENSOKYO_ALTAR) {
            this.close();
            return;
        }
    }

    @Override
    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        return super.onAnyClick(index, type, action);
    }

    @Override
    public void onOpen() {
        super.onOpen();
    }

    @Override
    public void onClose() {
        super.onClose();

        blockEntity.method_5431();
    }
}
