package cc.thonly.reverie_dreams.inventory;

import lombok.Getter;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import java.util.function.Function;

@Getter
public class PredicateInventory extends class_1277 {
    public static final Factory ARMOR_SLOT_FACTORY = (size, predicate) -> new PredicateInventory(1, predicate);
    private final Function<class_1799, Boolean> predicate;

    public PredicateInventory(Function<class_1799, Boolean> predicate) {
        super(1);
        this.predicate = predicate;
    }

    public PredicateInventory(int size, Function<class_1799, Boolean> predicate) {
        super(size);
        this.predicate = predicate;
    }

    @Override
    public boolean method_27070(class_1799 stack) {
        return super.method_27070(stack) && this.predicate.apply(stack);
    }

    public interface Factory {
        public PredicateInventory get(int size, Function<class_1799, Boolean> predicate);
    }
}
