package cc.thonly.reverie_dreams.item;

import cc.thonly.polymer.PolymerItemHelper;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.armor.*;
import cc.thonly.reverie_dreams.component.BattleStickRecorder;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.item.armor.DreamArmorItem;
import cc.thonly.reverie_dreams.item.armor.EarphoneItem;
import cc.thonly.reverie_dreams.item.armor.KoishiHatItem;
import cc.thonly.reverie_dreams.item.base.*;
import cc.thonly.reverie_dreams.item.builder.RoleCard;
import cc.thonly.reverie_dreams.item.material.DreamMaterial;
import cc.thonly.reverie_dreams.item.material.MagicIceMaterial;
import cc.thonly.reverie_dreams.item.material.SilverMaterial;
import cc.thonly.reverie_dreams.item.prop.*;
import cc.thonly.reverie_dreams.item.prop.debug.BattleStickItem;
import cc.thonly.reverie_dreams.item.prop.debug.OwnerStickItem;
import cc.thonly.reverie_dreams.item.template.DanmakuShapeCreatorItem;
import cc.thonly.reverie_dreams.item.template.RoleCardItem;
import cc.thonly.reverie_dreams.item.template.RoleFollowerArchiveItem;
import cc.thonly.reverie_dreams.item.template.SpellCardTemplateItem;
import cc.thonly.reverie_dreams.item.weapon.*;
import cc.thonly.reverie_dreams.sound.JukeboxSongInit;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_10124;
import net.minecraft.class_10712;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1821;
import net.minecraft.class_1839;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_3902;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.component.type.*;
import net.minecraft.item.*;
import net.minecraft.registry.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ModItems {
    public static final List<class_1792> ITEM_LIST = new ArrayList<>();

    public static final Supplier<class_1799> NOT_COMPLETED = () -> {
        class_1799 itemStack = new class_1799(class_1802.field_8077);
        itemStack.method_57379(class_9334.field_50239, class_2561.method_43470("§cThis page is not completed"));
        return itemStack;
    };

    // 调试
    public static final class_1792 BATTLE_STICK = registerSimpleItem("battle_stick", BattleStickItem::new, new class_1792.class_1793().
            method_7889(1)
            .method_57349(ModDataComponentTypes.BATTLE_STICK_RECORDER, BattleStickRecorder.empty()));
    public static final class_1792 OWNER_STICK = registerSimpleItem("owner_stick", OwnerStickItem::new, new class_1792.class_1793()
            .method_7889(1));

    // 图标
    public static final class_1792 ICON = registerCreativeTabIcon("icon", class_1792::new, new class_1792.class_1793());
    public static final class_1792 FUMO_ICON = registerCreativeTabIcon("fumo_icon", class_1792::new, new class_1792.class_1793());
    public static final class_1792 ROLE_ICON = registerCreativeTabIcon("role_icon", class_1792::new, new class_1792.class_1793());
    public static final class_1792 SPAWN_EGG = registerCreativeTabIcon("spawn_egg", class_1792::new, new class_1792.class_1793()
            .method_57349(class_9334.field_49644, SpawnEggItem.DEFAULT_COLOR));
    public static final class_1792 DANMAKU = registerCreativeTabIcon("danmaku", class_1792::new, new class_1792.class_1793());

    // 材料
    public static final class_1792 POINT = registerItem("point", class_1792::new, new class_1792.class_1793());
    public static final class_1792 POWER = registerItem("power", class_1792::new, new class_1792.class_1793());
    public static final class_1792 DANMAKU_CORE = registerItem("danmaku_core", class_1792::new, new class_1792.class_1793()
            .method_57349(class_9334.field_49641, true));
    public static final class_1792 UPGRADED_HEALTH_FRAGMENT = registerItem("upgraded_health_fragment", class_1792::new, new class_1792.class_1793());
    public static final class_1792 BOMB_FRAGMENT = registerItem("bomb_fragment", class_1792::new, new class_1792.class_1793());
    public static final class_1792 RED_ORB = registerItem("red_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 BLUE_ORB = registerItem("blue_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 YELLOW_ORB = registerItem("yellow_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 GREEN_ORB = registerItem("green_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 PURPLE_ORB = registerItem("purple_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 YIN_YANG_ORB = registerItem("yin-yang_orb", class_1792::new, new class_1792.class_1793());
    public static final class_1792 SPEED_FEATHER = registerItem("speed_feather", class_1792::new, new class_1792.class_1793()
            .method_57349(class_9334.field_49641, true));
    public static final class_1792 DREAM_CRYSTAL_FRAGMENT = registerItem("dream_crystal_fragment", class_1792::new, new class_1792.class_1793().method_57349(class_9334.field_49641, true));
    public static final class_1792 COPPER_COIN = registerItem("copper_coin", class_1792::new, new class_1792.class_1793().method_7889(96));
    public static final class_1792 SILVER_COIN = registerItem("silver_coin", class_1792::new, new class_1792.class_1793().method_7889(96));
    public static final class_1792 GOLD_COIN = registerItem("gold_coin", class_1792::new, new class_1792.class_1793().method_7889(96));

    // 道具
    public static final class_1792 TOUHOU_HELPER = registerItem("touhou_helper", TouhouHelperItem::new, new class_1792.class_1793()
            .method_7889(1)
            .method_7894(class_1814.field_8904)
            .method_57349(class_9334.field_49641, true));
    public static final class_1792 UPGRADED_HEALTH = registerItem("upgraded_health", UpgradedHealthItem::new, new class_1792.class_1793());
    public static final class_1792 BOMB = registerItem("bomb", BombItem::new, new class_1792.class_1793().method_62832(2.0f));
    public static final class_1792 CROSSING_CHISEL = registerItem("crossing_chisel", CrossingChisel::new, new class_1792.class_1793().method_62832(3.0f)
            .method_57349(ModDataComponentTypes.MAX_DISTANCE, CrossingChisel.DEFAULT_VALUE)
            .method_7889(1)
            .method_7895(150));
    public static final class_1792 GAP_BALL = registerItem("gap_ball", GapBall::new, new class_1792.class_1793().method_7889(1));
    public static final class_1792 TIME_STOP_CLOCK = registerItem("time_stop_clock", TimeStopClock::new, new class_1792.class_1793().method_7889(1).method_7895(200).method_61647(class_3489.field_52385));
    public static final class_1792 EARPHONE = registerItem("earphone", EarphoneItem::new, new class_1792.class_1793().method_7895(class_8051.field_41934.method_56690(EarphoneArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 KOISHI_HAT = registerItem("koishi_hat", KoishiHatItem::new, new class_1792.class_1793().method_7895(class_8051.field_41934.method_56690(KoishiHatArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 FUMO_LICENSE = registerItem("fumo_license", FumoLicenseItem::new, new class_1792.class_1793());
    public static final class_1792 CURSED_DECOY_DOLl = registerItem("cursed_decoy_doll", CursedDecoyDollItem::new, new class_1792.class_1793());
    public static final class_1792 VAISRAVANAS_PAGODA = registerItem("vaisravanas_pagoda", VaisravanasPagodaItem::new, new class_1792.class_1793().method_7889(1).method_7895(250).method_61647(ModTags.ItemTypeTag.VAISRAVANAS_PAGODA));
    public static final class_1792 DREAM_PILLOW = registerItem("dream_pillow", DreamPillowItem::new, new class_1792.class_1793().method_7895(4));
    public static final class_1792 TENGU_SHIELD = registerItem("tengu_shield", TenguShieldItem::new, TenguShieldItem.createItemSettings());
    public static final class_1792 TENGU_CAMERA = registerItem("tengu_camera", TenguCameraItem::new, new class_1792.class_1793().method_7889(1).method_7895(250).method_61647(class_3489.field_54061));
    public static final class_1792 BAD_APPLE = registerItem("bad_apple", BadAppleItem::new, new class_1792.class_1793().method_19265(class_4176.field_18658).method_7889(16).method_7894(class_1814.field_8904));
    public static final class_1792 EXORCISM_PAPER = registerItem("exorcism_paper", ExorcismPaperItem::new, new class_1792.class_1793().method_7889(16));

    // 武器
    public static final class_1792 HAKUREI_CANE = registerItem("hakurei_cane", (settings) -> new HakureiCane(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 BAGUA_FURNACE = registerItem("bagua_furnace", BaguaFurnace::new, new class_1792.class_1793().method_7889(1).method_7895(200).method_57349(class_9334.field_53964, new class_10124(5, class_1839.field_8949, class_6880.method_40223(class_3417.field_15013), false, new ArrayList<>())).method_61648(class_1802.field_22020));
    public static final class_1792 WIND_BLESSING_CANE = registerItem("wind_blessing_cane", (settings) -> new WindBlessingCane(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_BROOM = registerItem("magic_broom", (settings) -> new MagicBroom(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 GUNGNIR = registerItem("gungnir", (settings) -> new Gungnir(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 LEVATIN = registerItem("levatin", (settings) -> new Levatin(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 ROKANKEN = registerItem("rokanken", (settings) -> new Rokanken(2f, 0.5f - 2.4f, settings), new class_1792.class_1793());
    public static final class_1792 HAKUROKEN = registerItem("hakuroken", (settings) -> new Hakuroken(2f, 1f - 2.4f, settings), new class_1792.class_1793());
    public static final class_1792 PAPILIO_PATTERN_FAN = registerItem("papilio_pattern_fan", (settings) -> new PapilioPatternFan(1f - 4f, 1f - 2.4f, settings), new class_1792.class_1793());
    public static final class_1792 HORAI_DAMA_NO_EDA = registerItem("horai-dama_no_eda", (settings) -> new HoraiDamaNoEdaItem(0, 0, settings), new class_1792.class_1793());
    public static final class_1792 MAPLE_LEAF_FAN = registerItem("maple_leaf_fan", (settings) -> new MapleLeafFan(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 IBUKIHO = registerItem("ibukiho", (settings) -> new Ibukiho(1f, -2.4f, settings), new class_1792.class_1793()
            .method_62832(130f)
            .method_24359()
            .method_62833(new class_4174.class_4175()
                            .method_19240()
                            .method_19237(-4f)
                            .method_19242(),
                    class_10124.method_62850()
                            .method_62852(3f)
                            .method_62857(class_3417.field_20613)
                            .method_62851()
            ));
    public static final class_1792 SWORD_OF_HISOU = registerItem("sword_of_hisou", (settings) -> new SwordOfHisou(1f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 MANPOZUCHI = registerItem("manpozuchi", (settings) -> new ManpozuchiItem(3.5f, -2.5f, settings), new class_1792.class_1793());
    public static final class_1792 NUE_TRIDENT = registerItem("nue_trident", (settings) -> new NueTrident(3.5f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 TRUMPET_GUN = registerItem("trumpet_gun", TrumpetGun::new, new class_1792.class_1793().method_7889(1).method_7895(150).method_61648(class_1802.field_8494));
    public static final class_1792 TREASURE_HUNTING_ROD = registerItem("treasure_hunting_rod", (settings) -> new TreasureHuntingRod(2f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 DEATH_SCYTHE = registerItem("death_scythe", (settings) -> new DeathScytheItem(1f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 VIOLIN = registerItem("violin", MusicalInstrumentItem::new, new class_1792.class_1793()
            .method_7889(1)
            .equipmentSlot((livingEntity, stack) -> class_1304.field_6169)
            .method_57349(ModDataComponentTypes.NOTE_TYPE, class_2766.field_12650));
    public static final class_1792 KEYBOARD = registerItem("keyboard", MusicalInstrumentItem::new, new class_1792.class_1793()
            .method_7889(1)
            .equipmentSlot((livingEntity, stack) -> class_1304.field_6169)
            .method_57349(ModDataComponentTypes.NOTE_TYPE, class_2766.field_18289));
    public static final class_1792 TRUMPET = registerItem("trumpet", MusicalInstrumentItem::new, new class_1792.class_1793()
            .method_7889(1)
            .equipmentSlot((livingEntity, stack) -> class_1304.field_6169)
            .method_57349(ModDataComponentTypes.NOTE_TYPE, class_2766.field_18286));

    // 银装备
    public static final class_1792 RAW_SILVER = registerItem("raw_silver", class_1792::new, new class_1792.class_1793());
    public static final class_1792 SILVER_INGOT = registerItem("silver_ingot", class_1792::new, new class_1792.class_1793());
    public static final class_1792 SILVER_NUGGET = registerItem("silver_nugget", class_1792::new, new class_1792.class_1793());
    public static final class_1792 SILVER_SWORD = registerItem("silver_sword", (settings) -> new SwordItem(SilverMaterial.INSTANCE, 3.0f, -2.4f, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274));
    public static final class_1792 SILVER_AXE = registerItem("silver_axe", (settings) -> new class_1743(SilverMaterial.INSTANCE, 6.0f, -2.8f, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274));
    public static final class_1792 SILVER_PICKAXE = registerItem("silver_pickaxe", (settings) -> new PickaxeItem(SilverMaterial.INSTANCE, 1.0f, -2.8f, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274));
    public static final class_1792 SILVER_SHOVEL = registerItem("silver_shovel", (settings) -> new class_1821(SilverMaterial.INSTANCE, 1.5f, -3.0f, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274));
    public static final class_1792 SILVER_HOE = registerItem("silver_hoe", (settings) -> new class_1794(SilverMaterial.INSTANCE, -2.0f, -1.0f, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274));
    public static final class_1792 SILVER_HELMET = registerItem("silver_helmet", (settings) -> new ArmorItem(SilverArmorMaterial.INSTANCE, class_8051.field_41934, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274).method_7895(class_8051.field_41934.method_56690(SilverArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 SILVER_CHESTPLATE = registerItem("silver_chestplate", (settings) -> new ArmorItem(SilverArmorMaterial.INSTANCE, class_8051.field_41935, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274).method_7895(class_8051.field_41935.method_56690(SilverArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 SILVER_LEGGINGS = registerItem("silver_leggings", (settings) -> new ArmorItem(SilverArmorMaterial.INSTANCE, class_8051.field_41936, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274).method_7895(class_8051.field_41936.method_56690(SilverArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 SILVER_BOOTS = registerItem("silver_boots", (settings) -> new ArmorItem(SilverArmorMaterial.INSTANCE, class_8051.field_41937, settings), new class_1792.class_1793().method_57349(ModDataComponentTypes.SILVER_ITEM, class_3902.field_17274).method_7895(class_8051.field_41937.method_56690(SilverArmorMaterial.BASE_DURABILITY)));

    // 女仆装备
    public static final class_1792 KNIFE = registerItem("knife", (settings) -> new Knife(0f, 0f, settings), new class_1792.class_1793().method_7889(1)
            .method_57349(ModDataComponentTypes.Danmaku.TEMPLATE, Touhou.id("single").toString())
            .method_57349(ModDataComponentTypes.Danmaku.DAMAGE, 2.0f)
            .method_57349(ModDataComponentTypes.Danmaku.SPEED, 0.5f)
            .method_57349(ModDataComponentTypes.Danmaku.SCALE, 0.8f)
            .method_57349(ModDataComponentTypes.Danmaku.COUNT, 1)
            .method_57349(ModDataComponentTypes.Danmaku.TILE, false)
            .method_57349(ModDataComponentTypes.Danmaku.INFINITE, false));
    public static final class_1792 MAID_HAIRBAND = registerItem("maid_hairband", (settings) -> new ArmorItem(MaidArmorMaterial.INSTANCE, class_8051.field_41934, settings), new class_1792.class_1793().method_7895(class_8051.field_41934.method_56690(MaidArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAID_UPPER_SKIRT = registerItem("maid_upper_skirt", (settings) -> new ArmorItem(MaidArmorMaterial.INSTANCE, class_8051.field_41935, settings), new class_1792.class_1793().method_7895(class_8051.field_41935.method_56690(MaidArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAID_LOWER_SKIRT = registerItem("maid_lowerband", (settings) -> new ArmorItem(MaidArmorMaterial.INSTANCE, class_8051.field_41936, settings), new class_1792.class_1793().method_7895(class_8051.field_41936.method_56690(MaidArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAID_SHOE = registerItem("maid_shoe", (settings) -> new ArmorItem(MaidArmorMaterial.INSTANCE, class_8051.field_41937, settings), new class_1792.class_1793().method_7895(class_8051.field_41937.method_56690(MaidArmorMaterial.BASE_DURABILITY)));

    // 魔法冰装备
    public static final class_1792 ICE_SCALES = registerItem("ice_scales", class_1792::new, new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_SWORD = registerItem("magic_ice_sword", (settings) -> new SwordItem(MagicIceMaterial.INSTANCE, 3.0f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_AXE = registerItem("magic_ice_axe", (settings) -> new class_1743(MagicIceMaterial.INSTANCE, 6.0f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_PICKAXE = registerItem("magic_ice_pickaxe", (settings) -> new PickaxeItem(MagicIceMaterial.INSTANCE, 1.0f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_SHOVEL = registerItem("magic_ice_shovel", (settings) -> new class_1821(MagicIceMaterial.INSTANCE, 1.5f, -3.0f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_HOE = registerItem("magic_ice_hoe", (settings) -> new class_1794(MagicIceMaterial.INSTANCE, -2.0f, -1.0f, settings), new class_1792.class_1793());
    public static final class_1792 MAGIC_ICE_HELMET = registerItem("magic_ice_helmet", (settings) -> new ArmorItem(MagicIceArmorMaterial.INSTANCE, class_8051.field_41934, settings), new class_1792.class_1793().method_7895(class_8051.field_41934.method_56690(MagicIceArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAGIC_ICE_CHESTPLATE = registerItem("magic_ice_chestplate", (settings) -> new ArmorItem(MagicIceArmorMaterial.INSTANCE, class_8051.field_41935, settings), new class_1792.class_1793().method_7895(class_8051.field_41935.method_56690(MagicIceArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAGIC_ICE_LEGGINGS = registerItem("magic_ice_leggings", (settings) -> new ArmorItem(MagicIceArmorMaterial.INSTANCE, class_8051.field_41936, settings), new class_1792.class_1793().method_7895(class_8051.field_41936.method_56690(MagicIceArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 MAGIC_ICE_BOOTS = registerItem("magic_ice_boots", (settings) -> new ArmorItem(MagicIceArmorMaterial.INSTANCE, class_8051.field_41937, settings), new class_1792.class_1793().method_7895(class_8051.field_41937.method_56690(MagicIceArmorMaterial.BASE_DURABILITY)));

    // 梦境装备
    public static final class_1792 DREAM_SWORD = registerItem("dream_sword", (settings) -> new SwordItem(DreamMaterial.INSTANCE, 3.0f, -2.4f, settings), new class_1792.class_1793());
    public static final class_1792 DREAM_AXE = registerItem("dream_axe", (settings) -> new class_1743(DreamMaterial.INSTANCE, 6.0f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 DREAM_PICKAXE = registerItem("dream_pickaxe", (settings) -> new PickaxeItem(DreamMaterial.INSTANCE, 1.0f, -2.8f, settings), new class_1792.class_1793());
    public static final class_1792 DREAM_SHOVEL = registerItem("dream_shovel", (settings) -> new class_1821(DreamMaterial.INSTANCE, 1.5f, -3.0f, settings), new class_1792.class_1793());
    public static final class_1792 DREAM_HOE = registerItem("dream_hoe", (settings) -> new class_1794(DreamMaterial.INSTANCE, -2.0f, -1.0f, settings), new class_1792.class_1793());
    public static final class_1792 DREAM_HELMET = registerItem("dream_helmet", (settings) -> new DreamArmorItem(class_8051.field_41934, settings), new class_1792.class_1793().method_7895(class_8051.field_41934.method_56690(DreamArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 DREAM_CHESTPLATE = registerItem("dream_chestplate", (settings) -> new DreamArmorItem(class_8051.field_41935, settings), new class_1792.class_1793().method_7895( class_8051.field_41935.method_56690(DreamArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 DREAM_LEGGINGS = registerItem("dream_leggings", (settings) -> new DreamArmorItem(class_8051.field_41936, settings), new class_1792.class_1793().method_7895(class_8051.field_41936.method_56690(DreamArmorMaterial.BASE_DURABILITY)));
    public static final class_1792 DREAM_BOOTS = registerItem("dream_boots", (settings) -> new DreamArmorItem(class_8051.field_41937, settings), new class_1792.class_1793().method_7895(class_8051.field_41937.method_56690(DreamArmorMaterial.BASE_DURABILITY)));

    // 模板
    public static final class_1792 DANMAKU_SHAPE_CREATOR = registerItem("danmaku_recipe_creator", DanmakuShapeCreatorItem::new, new class_1792.class_1793());
    public static final class_1792 SPELL_CARD_TEMPLATE = registerItem("spell_card_template", SpellCardTemplateItem::new, new class_1792.class_1793());
    public static final class_1792 ROLE_CARD = registerItem("role_card", RoleCardItem::new, new class_1792.class_1793().method_7889(1)
            .method_57349(class_9334.field_56400, class_10712.field_56318.method_67215(class_9334.field_49644, true))
            .method_57349(class_9334.field_49644, new class_9282(RoleCard.DEFAULT_COLOR.intValue())));
    public static final class_1792 ROLE_ARCHIVE = registerItem("role_archive", RoleFollowerArchiveItem::new, new class_1792.class_1793().method_7889(1));

    // DISC
    public static final class_1792 HR01_01 = registerAlbum("hr01_01", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.HR01_01.getJukeboxSongRegistryKey()));
    public static final class_1792 HR02_08 = registerAlbum("hr02_08", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.HR02_08.getJukeboxSongRegistryKey()));
    public static final class_1792 HR03_01 = registerAlbum("hr03_01", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.HR03_01.getJukeboxSongRegistryKey()));
    public static final class_1792 MELODIC_TASTE_NIGHTMARE_BEFORE_CROSSROADS = registerAlbum("melodic-taste-nightmare-before-crossroads", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.MELODIC_TASTE_NIGHTMARE_BEFORE_CROSSROADS.getJukeboxSongRegistryKey()));
    public static final class_1792 YV_FLOWER_CLOCK_AND_DREAMS = registerAlbum("yv_flower_clock_and_dreams", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.YV_FLOWER_CLOCK_AND_DREAMS.getJukeboxSongRegistryKey()));
    public static final class_1792 GLOWING_NEEDLES_LITTLE_PEOPLE = registerAlbum("glowing_needles_little_people", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.GLOWING_NEEDLES_LITTLE_PEOPLE.getJukeboxSongRegistryKey()));
    public static final class_1792 COOKIE = registerAlbum("cookie", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.COOKIE.getJukeboxSongRegistryKey()));
    public static final class_1792 BADAPPLE = registerAlbum("bad-apple", AlbumItem::new, new class_1792.class_1793().method_60745(JukeboxSongInit.BAD_APPLE.getJukeboxSongRegistryKey()));

    static {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41063).register(itemGroup -> {
            itemGroup.method_45421(BATTLE_STICK);
            itemGroup.method_45421(OWNER_STICK);
        });
    }

    public static void registerItems() {
        List<class_1792> silverItems = new ArrayList<>(List.of(SILVER_SWORD, SILVER_AXE, SILVER_PICKAXE, SILVER_HOE, SILVER_HOE));
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(itemGroup -> {
            itemGroup.addAfter(class_1802.field_23984, AlbumItem.ITEMS.stream().map(class_1792::method_7854).toList());
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!world.method_8608() && silverItems.contains(player.method_5998(hand).method_7909())) {
                if (entity instanceof class_1309 livingEntity) {
                    class_5455 registryManager = world.method_30349();
                    class_2378<class_1299<?>> registry = registryManager.method_30530(class_7924.field_41266);
                    Optional<class_6885.class_6888<class_1299<?>>> listOptional = registry.method_46733(class_3483.field_46232);
                    if (listOptional.isPresent()) {
                        class_6885.class_6888<class_1299<?>> list = listOptional.get();
                        boolean contains = list.method_40241(class_6880.method_40223(livingEntity.method_5864()));
                        if (contains) {
                            livingEntity.method_64397((class_3218) world, world.method_48963().method_48831(), 1.0F);
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    public static class_1792 registerItem(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        class_1792 item = registerSimpleItem(id, factory, settings);
        ITEM_LIST.add(item);
        return item;
    }

    public static class_1792 registerCreativeTabIcon(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return registerSimpleItem(id, factory, settings);
    }

    public static class_1792 registerAlbum(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return registerSimpleItem(id, factory, settings);
    }

    public static class_1792 registerSimpleItem(class_2960 id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        class_1792 item = factory.apply(settings.method_63686(keyOf(id)));
        class_2378.method_10230(class_7923.field_41178, id, item);
        ItemTypeGroup.join(item);
        PolymerItemHelper.registerOverlay(item);
        return item;
    }

    public static class_1792 registerSimpleItem(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        return registerSimpleItem(Touhou.id(name), factory, settings);
    }

    public static class_5321<class_1792> keyOf(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41197, id);
    }

    public static class_5321<class_1792> keyOf(String id) {
        return class_5321.method_29179(class_7924.field_41197, Touhou.id(id));
    }

    public static class_5321<class_1792> keyOf(class_5321<class_2248> blockKey) {
        return class_5321.method_29179(class_7924.field_41197, blockKey.method_29177());
    }

    public static List<class_1792> getItemView() {
        return List.copyOf(ITEM_LIST);
    }
}
