package cc.thonly.reverie_dreams.item.prop;

import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.entity.ModEntityHolders;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.base.IDanmakuItem;
import cc.thonly.reverie_dreams.item.base.SwordItem;
import cc.thonly.reverie_dreams.item.material.SilverMaterial;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_9323;
import net.minecraft.class_9336;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@SuppressWarnings("unchecked")
@Setter
@Getter
public class Knife extends SwordItem implements IDanmakuItem {

    public Knife(float attackDamage, float attackSpeed, class_1793 settings) {
        super(
                SilverMaterial.INSTANCE,
                attackDamage + 3.0f,
                attackSpeed - 2f,
                settings
        );
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 heldItemStack = user.method_5998(hand);
        class_1799 itemStack = new class_1799(ModEntityHolders.KNIFE_DISPLAY);
        class_9323 components = heldItemStack.method_57353();
        Iterator<class_9336<?>> iterator = components.method_57833().iterator();
        while (iterator.hasNext()) {
            class_9336<Object> next = (class_9336<Object>) iterator.next();
            itemStack.method_57379(next.comp_2443(), next.comp_2444());
        }
        Boolean isInfinite = itemStack.method_58695(ModDataComponentTypes.Danmaku.INFINITE, false);
        if (!world.field_9236 && world instanceof class_3218 serverWorld && user instanceof class_3222 player) {
            class_1796 cooldownManager = player.method_7357();
            for (int i = 0; i < itemStack.method_58695(ModDataComponentTypes.Danmaku.COUNT, 1); i++) {
                this.shoot(serverWorld, user, hand);
            }
            cooldownManager.method_62835(heldItemStack, 10);
            if (!isInfinite) {
                itemStack.method_61653(1, user);
            }
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), SoundEventInit.FIRE, class_3419.field_15254, 1f, 1.0f);
            return class_1269.field_52422;
        }
        user.method_7259(class_3468.field_15372.method_14956(this));
        return class_1269.field_5812;
    }

    public void shoot(class_3218 serverWorld, class_1657 user, class_1268 hand) {
        this.spawn(serverWorld, user, hand);
    }

    public void spawn(class_3218 serverWorld, class_1657 user, class_1268 hand) {
        Random random = new Random();
        class_1799 heldItemStack = user.method_5998(hand);
        class_1799 itemStack = new class_1799(ModEntityHolders.KNIFE_DISPLAY);
        class_9323 components = heldItemStack.method_57353();
        Iterator<class_9336<?>> iterator = components.method_57833().iterator();
        while (iterator.hasNext()) {
            class_9336<Object> next = (class_9336<Object>) iterator.next();
            itemStack.method_57379(next.comp_2443(), next.comp_2444());
        }
        class_1799 stack = itemStack.method_7972();
        float pitch = user.method_36455();
        float yaw = user.method_36454();

        class_1792 item = stack.method_7909();

        List<DanmakuEntity> list = new ArrayList<>();
        DanmakuEntity danmakuEntity = new DanmakuEntity(
                (class_1309) user,
                serverWorld,
                user.method_23317(),
                user.method_23318(),
                user.method_23321(),
                stack.method_7972(),
                pitch,
                yaw,
                1.4f,
                0f,
                5.0f,
                0.4f
        );
        list.add(danmakuEntity);
        for (int i = 0; i < 3; i++) {
            int i1 = random.nextInt(-5, 5);
            list.add(new DanmakuEntity(
                    (class_1309) user,
                    serverWorld,
                    user.method_23317(),
                    user.method_23318(),
                    user.method_23321(),
                    stack.method_7972(),
                    pitch+i1/1.5f,
                    yaw+i1,
                    1.4f,
                    0f,
                    5.0f,
                    0.4f
            ));
        }
        list.forEach(serverWorld::method_8649);
    }
}
