package cc.thonly.reverie_dreams.item.prop;

import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.dialog.DialogInit;
import cc.thonly.reverie_dreams.entity.ModEntities;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeCategoryGui;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.server.DelayedTask;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_6880;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TouhouHelperItem extends class_1792 {

    public TouhouHelperItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.method_8608() && user instanceof class_3222 player) {
            class_1799 itemStack = user.method_5998(hand);
            user.method_7315(itemStack, hand);
            user.method_7259(class_3468.field_15372.method_14956(this));
            user.method_71753(class_6880.method_40223(DialogInit.MAIN_HELP));
            world.method_45447(null, player.method_24515(), class_3417.field_17481, class_3419.field_15248);
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    public static boolean resolve(class_1799 book, class_2168 commandSource, @Nullable class_1657 player) {
        class_9302 writtenBookContentComponent = book.method_58694(class_9334.field_49606);
        if (writtenBookContentComponent != null && !writtenBookContentComponent.comp_2423()) {
            class_9302 writtenBookContentComponent2 = writtenBookContentComponent.method_57521(commandSource, player);
            if (writtenBookContentComponent2 != null) {
                book.method_57379(class_9334.field_49606, writtenBookContentComponent2);
                return true;
            }
            book.method_57379(class_9334.field_49606, writtenBookContentComponent.method_57527());
        }
        return false;
    }

    public static class HelperGui extends BookGui {

        public HelperGui(class_3222 player) {
            super(player, getDefaultBookElement());
            this.init();
        }

        public void init() {
            this.player.method_17356(class_3417.field_17481, class_3419.field_15248, 1.0f, 1.0f);
        }

        public static BookElementBuilder getDefaultBookElement() {
            BookElementBuilder builder = new BookElementBuilder();
            // 1
            builder.addPage(
                    class_2561.method_43473().method_27693("欢迎游玩Gensokyo: Reverie of Lost Dreams，本书将介绍模组的游玩指南"),
                    class_2561.method_43473(),
                    class_2561.method_43473().method_27693("导航目录："),
                    class_2561.method_43473().method_27693("> [祭坛摆放]").method_10862(class_2583.field_24360.method_10958(new class_2558.class_10605(3))),
                    class_2561.method_43473().method_27693("> [弹幕合成]").method_10862(class_2583.field_24360.method_10958(new class_2558.class_10605(4))),
                    class_2561.method_43473().method_27693("> [Fumo制作]").method_10862(class_2583.field_24360.method_10958(new class_2558.class_10605(6))),
                    class_2561.method_43473().method_27693("> [角色养成]").method_10862(class_2583.field_24360.method_10958(new class_2558.class_10605(7))),
                    class_2561.method_43473().method_27693("").method_10862(class_2583.field_24360),
                    class_2561.method_43473().method_27693("配方管理器：/touhou recipe").method_10862(class_2583.field_24360)
            );
            // 2
            builder.addPage(class_2561.method_43473());
            // 3
            builder.addPage(
                    class_2561.method_43470("祭坛摆放："),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§c⏹§b⏹§b⏹§b⏹§e⏹§b⏹§b⏹§b⏹§c⏹"),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹"),
                    class_2561.method_43473().method_27693("§b⏹：").method_10852(class_2561.method_43471(class_1802.field_8162.method_7876())),
                    class_2561.method_43473().method_27693("§c⏹：").method_10852(class_2561.method_43471(ModBlocks.SPIRITUAL.strippedLog().method_63499())),
                    class_2561.method_43473().method_27693("§e⏹：").method_10852(class_2561.method_43471(ModBlocks.GENSOKYO_ALTAR.method_63499())),
                    class_2561.method_43473().method_27693("注意：").method_27693("§c⏹§r一共摆放三层")
            );
            // 4
            builder.addPage(
                    class_2561.method_43473().method_27693("弹幕工作台："),
                    class_2561.method_43473().method_27693("弹幕工作台是一个合成弹幕的工作方块，里面共有5个槽位可以摆放物品合成，合成类型为有序合成"),
                    class_2561.method_43473(),
                    class_2561.method_43473().method_27693("合成配方："),
                    class_2561.method_43473().method_27693("§c⏹§c⏹§c⏹"),
                    class_2561.method_43473().method_27693("§c⏹§e⏹§c⏹"),
                    class_2561.method_43473().method_27693("§c⏹§c⏹§c⏹"),
                    class_2561.method_43473().method_27693("§e⏹").method_10852(class_2561.method_43471(class_1802.field_8465.method_7876())),
                    class_2561.method_43473().method_27693("§c⏹").method_10852(class_2561.method_43471(class_1802.field_8725.method_7876()))
            );
            // 5
            builder.addPage(
                    class_2561.method_43473().method_27693("弹幕工作台："),
                    class_2561.method_43473().method_27693("通用弹幕配方："),
                    class_2561.method_43473().method_27693("§a⏹ -> ").method_27693("任意颜料"),
                    class_2561.method_43473().method_27693("§b⏹ -> ").method_10852(class_2561.method_43471(class_1802.field_8450.method_7876())),
                    class_2561.method_43473().method_27693("§c⏹ -> ").method_10852(class_2561.method_43471(ModItems.POWER.method_7876())),
                    class_2561.method_43473().method_27693("§d⏹ -> ").method_10852(class_2561.method_43471(ModItems.POINT.method_7876())),
                    class_2561.method_43473().method_27693("§e⏹ -> ")
            );
            // 6
            builder.addPage(
                    class_2561.method_43473().method_27693("Fumo是指由日本株式会社Gift出品的一系列东方Project角色的布制玩偶，因其商品名带有“ふもふも（fumofumo）”字样而得名。"),
                    class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.FUMO_LICENSE.method_7876())).method_27693("+").method_27693(class_1299.field_6077.method_5882()).method_27693("=>").method_27693(ModEntities.FUMO_SELLER_VILLAGER.method_5882()),
                    class_2561.method_43473().method_27693("提示：每一天Fumo商人都会刷新新的Fumo，不要拖太久买哦!")
            );
            // 7
            builder.addPage(
                    class_2561.method_43473().method_27693("角色是指本Mod中的随从角色，可以使用蛋糕驯服，拥有背包，功能类似女仆"),
                    class_2561.method_43473().method_27693("角色可通过合成角色卡概率随机获取一种东方Project角色"),
                    class_2561.method_43473().method_27693("角色死亡后会变成").method_10852(class_2561.method_43471(ModItems.ROLE_ARCHIVE.method_7876())).method_27693("，需要在祭坛摆放一圈").method_27693(class_1802.field_8477.method_7876()).method_27693("x4才能复活你的角色")
            );

            builder.signed();
            return builder;
        }

        @Override
        public boolean onCommand(String command) {
            if (command.equals("/touhou ui_relay_recipe")) {
                this.close();
                DelayedTask.createFromSecond(this.player.method_5682(), 0.1f, () -> RecipeTypeCategoryGui.create(this.player));
            }
            return false;
        }

        @Override
        public void onPreviousPageButton() {
            super.onPreviousPageButton();
            this.player.method_17356(class_3417.field_17481, class_3419.field_15248, 1.0f, 1.0f);
        }

        @Override
        public void onNextPageButton() {
            super.onNextPageButton();
            this.player.method_17356(class_3417.field_17481, class_3419.field_15248, 1.0f, 1.0f);
        }

        @Override
        public void onTakeBookButton() {
            super.onTakeBookButton();
            this.close();
        }

    }
}
