package cc.thonly.reverie_dreams.item.prop.debug;

import cc.thonly.reverie_dreams.component.BattleStickRecorder;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class BattleStickItem extends class_1792 {
    public BattleStickItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        class_1937 world = user.method_37908();
        if (world.method_8608()) return class_1269.field_5812;

        BattleStickRecorder recorder = stack.method_58695(ModDataComponentTypes.BATTLE_STICK_RECORDER, new BattleStickRecorder("", ""));

        String uuid = entity.method_5667().toString();
        if (recorder.getTarget_0().isEmpty()) {
            recorder.setTarget_0(uuid);
            user.method_7353(class_2561.method_43470("已记录第一个目标：" + entity.method_5477().getString()), false);
        } else if (recorder.getTarget_1().isEmpty()) {
            recorder.setTarget_1(uuid);
            user.method_7353(class_2561.method_43470("已记录第二个目标：" + entity.method_5477().getString()), false);
            this.apply(recorder.getTarget_0(), recorder.getTarget_1(), (class_3218) world);

            recorder.setTarget_0("");
            recorder.setTarget_1("");
        }

        stack.method_57379(ModDataComponentTypes.BATTLE_STICK_RECORDER, recorder);
        user.method_6104(hand);
        return class_1269.field_52422;
    }

    public void apply(String entityUuid0, String entityUuid1, class_3218 world) {
        class_1309 target0 = getLivingEntityByUUID(world, entityUuid0);
        class_1309 target1 = getLivingEntityByUUID(world, entityUuid1);

        if (target0 != null && target1 != null) {
            target0.method_64397(world, target1.method_48923().method_48830(), 0);
            target1.method_64397(world, target0.method_48923().method_48830(), 0);
            if (target0 instanceof class_1308 mob0) {
                mob0.method_5980(target1);
            }
            if (target1 instanceof class_1308 mob1) {
                mob1.method_5980(target0);
            }
        }
    }

    private class_1309 getLivingEntityByUUID(class_3218 world, String uuidStr) {
        try {
            UUID uuid = UUID.fromString(uuidStr);
            class_1297 entity = world.method_66347(uuid);
            if (entity instanceof class_1308 living) {
                return living;
            }
        } catch (IllegalArgumentException ignored) {
        }
        return null;
    }

    @Override
    public boolean method_7886(class_1799 stack) {
        return true;
    }
}
