package cc.thonly.reverie_dreams.item.template;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.entity.npc.AbstractNPCEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCRole;
import cc.thonly.reverie_dreams.item.builder.RoleCard;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11419;
import net.minecraft.class_11426;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11525;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import java.util.*;
import java.util.function.Consumer;

@Getter
public class RoleCardItem extends class_1792 {
    public static final BiMap<String, UsingData> USING_DATA_MAP = HashBiMap.create();
    public static final class_3414 SOUND = class_3417.field_15126;

    public RoleCardItem(class_1793 settings) {
        super(settings);
    }

    public Optional<RoleCard> getRoleCardComponent(class_1799 itemStack) {
        class_2960 identifier = itemStack.method_58694(ModDataComponentTypes.ROLE_CARD_ID);
        if (identifier == null) {
            return Optional.empty();
        }
        RoleCard roleCard = RegistryManager.ROLE_CARD.method_63535(identifier);
        if (roleCard == null) {
            return Optional.empty();
        }
        return Optional.of(roleCard);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        if (!world.method_8608() && context.method_8045() instanceof class_3218 serverWorld && context.method_8036() instanceof class_3222 player) {
            class_1268 hand = context.method_20287();
            class_1799 itemStack = context.method_8041();
            Optional<RoleCard> roleCardWrapper = this.getRoleCardComponent(itemStack);
            if (roleCardWrapper.isPresent()) {
                RoleCard roleCard = roleCardWrapper.get();
                UUID uuid = UUID.randomUUID();
                UsingData data = new UsingData(player, serverWorld, context.method_8037().method_10084(), itemStack, roleCard);

                USING_DATA_MAP.put(uuid.toString(), data);
                class_11419 selectMenu = getSelectMenu(uuid.toString(), data);
                player.method_71753(class_6880.method_40223(selectMenu));
                player.method_6104(hand);
            }
        }
        return super.method_7884(context);
    }

//    @Override
//    public void appendTooltip(ItemStack stack, TooltipContext context, TooltipDisplayComponent displayComponent, Consumer<Text> textConsumer, TooltipType type) {
//        super.appendTooltip(stack, context, displayComponent, textConsumer, type);
//        Optional<RoleCard> roleCardComponent = this.getRoleCardComponent(stack);
//        if (roleCardComponent.isEmpty()) {
//            textConsumer.accept(Text.translatable("item.disabled"));
//            return;
//        }
//        if (roleCardComponent.get().isEmpty()) {
//            textConsumer.accept(Text.translatable("item.disabled"));
//            return;
//        }
//        textConsumer.accept(Text.translatable("item.tooltip.use"));
//    }

    public static class_11419 getSelectMenu(String uuid, UsingData data) {
        class_11426 dialog = new class_11426(
                new class_11417(
                        data.getItemStack().getName(),
                        Optional.empty(),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(
                                List.of(
                                        new class_11435(class_2561.method_43471("dialog.message.select"), 200)
                                )
                        ),
                        new ArrayList<>()
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        for (Map.Entry<class_2960, NPCRole> entry : data.id2Role.entrySet()) {
            class_2960 identifier = entry.getKey();
            NPCRole role = entry.getValue();
            class_1299<AbstractNPCEntity> entityType = role.get();
            class_2487 element = new class_2487();
            element.method_10582("session_id", uuid);
            element.method_10582("entity_id", identifier.toString());
            dialog.comp_4317().add(new class_11519(
                    new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471(entityType.method_5882())), 180),
                    Optional.of(new class_11525(new class_2558.class_11506(Touhou.id("role/summon"), Optional.of(element))))
            ));
        }
        class_2487 element = new class_2487();
        element.method_10582("session_id", uuid);
        element.method_10582("entity_id", "random");
        dialog.comp_4317().add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.random")), 180),
                Optional.of(new class_11525(new class_2558.class_11506(Touhou.id("role/summon"), Optional.of(element))))
        ));
        dialog.comp_4317().add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.exit")), 200),
                Optional.empty()
        ));
        return dialog;
    }

    @Getter
    public static class UsingData {
        private final class_3222 player;
        private final class_3218 world;
        private final class_1799 itemStack;
        private final class_2338 blockPos;
        private final RoleCard roleCard;
        private final Map<class_2960, NPCRole> id2Role = new Object2ObjectOpenHashMap<>();
        private final List<NPCRole> roleList = new ArrayList<>();

        public UsingData(class_3222 player, class_3218 world, class_2338 blockPos, class_1799 itemStack, RoleCard roleCard) {
            this.player = player;
            this.world = world;
            this.itemStack = itemStack;
            this.blockPos = blockPos;
            this.roleCard = roleCard;
            this.roleList.addAll(this.roleCard.stream().toList());
            for (NPCRole npcRole : this.roleList) {
                this.id2Role.put(npcRole.getId(), npcRole);
            }
        }
    }
}
