package cc.thonly.reverie_dreams.item.weapon;

import cc.thonly.reverie_dreams.interfaces.ILivingEntity;
import cc.thonly.reverie_dreams.item.base.PickaxeItem;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_9886;

public class ManpozuchiItem extends PickaxeItem {
    private static final int ATTACK_DAMAGE_MODIFIER_VALUE = 5;
    private static final float ATTACK_SPEED_MODIFIER_VALUE = -3.4f;
    public static final float MINING_SPEED_MULTIPLIER = 1.5f;
    private static final float HEAVY_SMASH_SOUND_FALL_DISTANCE_THRESHOLD = 5.0f;
    public static final float KNOCKBACK_RANGE = 3.5f;
    private static final float KNOCKBACK_POWER = 0.7f;

    public static final class_9886 MATERIAL = new class_9886(class_3481.field_49930, 59, 2.0F, 0.0F, 15, class_3489.field_52385);

    public ManpozuchiItem(float attackDamage, float attackSpeed, class_1793 settings) {
        super(MATERIAL, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean method_7885(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1309 user) {
        if (!world.field_9236 && user instanceof class_3222 player) {
            boolean b = super.method_7885(stack, state, world, pos, user);
            return b && !player.method_56992();
        }
        return super.method_7885(stack, state, world, pos, user);
    }

    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        boolean isSneaking = user.method_5715();
        class_1937 world = user.method_37908();
        if (!world.method_8608() && isSneaking && user instanceof class_3222 player) {
            class_1799 stackInHand = player.method_5998(hand);
            class_5131 attributes = entity.method_6127();
            class_1324 attributeInstance = attributes.method_45329(class_5134.field_47760);
            if (attributeInstance == null) {
                return class_1269.field_5811;
            }
            ILivingEntity lePlayerImpl = (ILivingEntity) entity;
            double state = lePlayerImpl.getManpozuchiUsingState();
            if (state >= 0.2) {
                attributeInstance.method_6192(state);
                lePlayerImpl.setManpozuchiUsingState(state - 0.1);
            } else {
                attributeInstance.method_6192(1.0);
                lePlayerImpl.setManpozuchiUsingState(1.0);
            }
            if (!user.method_56992()) {
                stackInHand.method_61653(1, user);
            }
            user.method_6104(hand);
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        boolean isSneaking = user.method_5715();
        if (!world.method_8608() && isSneaking && user instanceof class_3222 player) {
            class_1799 stackInHand = user.method_5998(hand);
            class_5131 attributes = player.method_6127();
            class_1324 attributeInstance = attributes.method_45329(class_5134.field_47760);
            if (attributeInstance == null) {
                return class_1269.field_5811;
            }
            ILivingEntity lePlayerImpl = (ILivingEntity) player;
            double state = lePlayerImpl.getManpozuchiUsingState();
            if (state >= 0.2) {
                attributeInstance.method_6192(state);
                lePlayerImpl.setManpozuchiUsingState(state - 0.1);
            } else {
                attributeInstance.method_6192(1.0);
                lePlayerImpl.setManpozuchiUsingState(1.0);
            }
            if (!user.method_56992()) {
                stackInHand.method_61653(1, user);
            }
            user.method_6104(hand);
            return class_1269.field_52422;
        }
        return super.method_7836(world, user, hand);
    }

    public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (shouldDealAdditionalDamage(attacker)) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            attacker.method_18799(attacker.method_18798().method_38499(class_2350.class_2351.field_11052, 0.009999999776482582));

            class_3222 serverPlayerEntity = null;
            if (attacker instanceof class_3222) {
                serverPlayerEntity = (class_3222)attacker;
                serverPlayerEntity.field_49989 = this.getCurrentExplosionImpactPos(serverPlayerEntity);
                serverPlayerEntity.method_60984(true);
                serverPlayerEntity.field_13987.method_14364(new class_2743(serverPlayerEntity));
            }

            if (target.method_24828()) {
                if (attacker instanceof class_3222) {
                    serverPlayerEntity = (class_3222)attacker;
                    serverPlayerEntity.method_58143(true);
                }

                class_3414 soundEvent = attacker.field_6017 > 5.0 ? class_3417.field_49924 : class_3417.field_49785;
                serverWorld.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), soundEvent, attacker.method_5634(), 1.0F, 1.0F);
            } else {
                serverWorld.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_49784, attacker.method_5634(), 1.0F, 1.0F);
            }

            knockbackNearbyEntities(serverWorld, attacker, target);
        }

    }

    private class_243 getCurrentExplosionImpactPos(class_3222 player) {
        return player.method_61165() && player.field_49989 != null && player.field_49989.field_1351 <= player.method_19538().field_1351 ? player.field_49989 : player.method_19538();
    }

    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (shouldDealAdditionalDamage(attacker)) {
            attacker.method_38785();
        }

    }

    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 var5 = damageSource.method_5526();
        if (var5 instanceof class_1309 livingEntity) {
            if (!shouldDealAdditionalDamage(livingEntity)) {
                return 0.0F;
            } else {
                double d = 3.0;
                double e = 8.0;
                double f = livingEntity.field_6017;
                double g;
                if (f <= 3.0) {
                    g = 4.0 * f;
                } else if (f <= 8.0) {
                    g = 12.0 + 2.0 * (f - 3.0);
                } else {
                    g = 22.0 + f - 8.0;
                }

                class_1937 var14 = livingEntity.method_37908();
                if (var14 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)var14;
                    return (float)(g + (double)class_1890.method_60160(serverWorld, livingEntity.method_59958(), target, damageSource, 0.0F) * f);
                } else {
                    return (float)g;
                }
            }
        } else {
            return 0.0F;
        }
    }

    private static void knockbackNearbyEntities(class_1937 world, class_1297 attacker, class_1297 attacked) {
        world.method_20290(2013, attacked.method_23312(), 750);
        world.method_8390(class_1309.class, attacked.method_5829().method_1014(3.5), getKnockbackPredicate(attacker, attacked)).forEach((entity) -> {
            class_243 vec3d = entity.method_19538().method_1020(attacked.method_19538());
            double d = getKnockback(attacker, entity, vec3d);
            class_243 vec3d2 = vec3d.method_1029().method_1021(d);
            if (d > 0.0) {
                entity.method_5762(vec3d2.field_1352, 0.699999988079071, vec3d2.field_1350);
                if (entity instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity;
                    serverPlayerEntity.field_13987.method_14364(new class_2743(serverPlayerEntity));
                }
            }

        });
    }

    private static Predicate<class_1309> getKnockbackPredicate(class_1297 attacker, class_1297 attacked) {
        return (entity) -> {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean var10000;
            label64: {
                bl = !entity.method_7325();
                bl2 = entity != attacker && entity != attacked;
                bl3 = !attacker.method_5722(entity);
                if (entity instanceof class_1321 tameableEntity) {
                    if (attacked instanceof class_1309 livingEntity) {
                        if (tameableEntity.method_6181() && tameableEntity.method_6171(livingEntity)) {
                            var10000 = true;
                            break label64;
                        }
                    }
                }

                var10000 = false;
            }

            boolean bl4;
            label56: {
                bl4 = !var10000;
                if (entity instanceof class_1531 armorStandEntity) {
                    if (armorStandEntity.method_6912()) {
                        var10000 = false;
                        break label56;
                    }
                }

                var10000 = true;
            }

            boolean bl5 = var10000;
            boolean bl6 = attacked.method_5858(entity) <= Math.pow(3.5, 2.0);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        };
    }

    private static double getKnockback(class_1297 attacker, class_1309 attacked, class_243 distance) {
        return (3.5 - distance.method_1033()) * 0.699999988079071 * (double)(attacker.field_6017 > 5.0 ? 2 : 1) * (1.0 - attacked.method_45325(class_5134.field_23718));
    }

    public static boolean shouldDealAdditionalDamage(class_1309 attacker) {
        return attacker.field_6017 > 1.5 && !attacker.method_6128();
    }

    @Nullable
    public class_1282 method_64193(class_1309 user) {
        return shouldDealAdditionalDamage(user) ? user.method_48923().method_61398(user) : super.method_64193(user);
    }
}
