package cc.thonly.reverie_dreams.mixin.entity;

import cc.thonly.reverie_dreams.effect.ModStatusEffects;
import cc.thonly.reverie_dreams.entity.GhostEntity;
import cc.thonly.reverie_dreams.entity.ai.goal.GhostStatusEffectTargetGoal;
import cc.thonly.reverie_dreams.interfaces.IPlayerEntity;
import cc.thonly.reverie_dreams.server.DelayedTask;
import cc.thonly.reverie_dreams.world.GameRulesInit;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements IPlayerEntity {

    @Shadow
    public abstract boolean method_56992();

    @Unique
    private static final long MAX_NON_SLEEPING_TIME = (long) (2 * 10 * 60 * 20) / 2;
    @Unique
    private long nonSleepingTime = 0L;
    @Unique
    private boolean sleep = false;
    @Unique
    private static final class_6880<class_1291> MENTAL_DISORDER = ModStatusEffects.MENTAL_DISORDER;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void tick(CallbackInfo ci) {
        this.nonSleepingTick();
        if (this.method_6113()) {
            if (this.method_6059(MENTAL_DISORDER)) {
                this.method_6016(MENTAL_DISORDER);
            }
            this.nonSleepingTime = 0;
            this.sleep = true;
        } else {
            this.sleep = false;
        }
    }

    @Unique
    public void nonSleepingTick() {
        if (this.method_56992()) {
            return;
        }
        MinecraftServer server = this.method_5682();
        class_1937 world = this.method_37908();
        if (server == null) {
            return;
        }
        if (world instanceof class_3218 serverWorld) {
            if (GhostStatusEffectTargetGoal.hasSilverArmor(this)) {
                this.nonSleepingTime = 0;
                return;
            }
            if (this.nonSleepingTime < MAX_NON_SLEEPING_TIME) {
                this.nonSleepingTime++;
            } else if (serverWorld.method_64395().method_8355(GameRulesInit.DO_GHOST)){
                this.trySpawnGhost();
                this.method_6092(new class_1293(ModStatusEffects.MENTAL_DISORDER, 20 * 60 * 5));
                DelayedTask.whenTick(server, () -> this.sleep, 20 * 60 * 2, this::trySpawnGhost, () -> {

                });
                this.nonSleepingTime = 0;
            }
        }
    }

    @Unique
    private void trySpawnGhost() {
        var server = this.method_5682();
        if (server == null) return;
        var world = this.method_37908();
        if (!(world instanceof class_3218 serverWorld)) return;
        boolean value = serverWorld.method_64395().method_8355(GameRulesInit.DO_GHOST);
        if (!value) return;
        if (world.equals(server.method_30002())) {
            class_2338 origin = this.method_24515();
            class_2338 a = this.getRandomPos(origin);
            class_2338 b = this.getRandomPos(origin);
            GhostEntity aMob = new GhostEntity(world);
            aMob.method_23327(a.method_10263(), a.method_10264(), a.method_10260());
            GhostEntity bMob = new GhostEntity(world);
            bMob.method_23327(b.method_10263(), b.method_10264(), b.method_10260());
            serverWorld.method_8649(aMob);
            serverWorld.method_8649(bMob);
        }
    }

    @Unique
    private class_2338 getRandomPos(class_2338 origin) {
        var world = this.method_37908();
        class_5819 random = world.method_8409();

        int offsetX = random.method_43048(11) - 5; // 0~10 - 5 => -5~5
        int offsetZ = random.method_43048(11) - 5;

        int surfaceY = world.method_8624(class_2902.class_2903.field_13202, origin.method_10263() + offsetX, origin.method_10260() + offsetZ);

        return new class_2338(origin.method_10263() + offsetX, surfaceY, origin.method_10260() + offsetZ);
    }

    @Inject(method = "writeCustomData", at = @At("TAIL"))
    protected void writeCustomData(class_11372 view, CallbackInfo ci) {
        super.method_5652(view);
        view.method_71466("NonSleepingTime", this.nonSleepingTime);
    }

    @Inject(method = "readCustomData", at = @At("TAIL"))
    protected void readCustomData(class_11368 view, CallbackInfo ci) {
        super.method_5749(view);
        this.nonSleepingTime = view.method_71425("NonSleepingTime", 0L);
    }

    @Unique
    @Override
    public void setNonSleepingTime(long time) {
        this.nonSleepingTime = time;
    }

    @Unique
    @Override
    public long getNonSleepingTime() {
        return this.nonSleepingTime;
    }

    //    @Inject(method = "damage", at = @At("HEAD"), cancellable = true)
//    public void damage(ServerWorld world, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
//        Entity attacker = source.getAttacker();
//        if(attacker == null) return;
//        if (!attacker.isAttackable()) {
//            return;
//        }
//        if(!world.isClient()) {
//            List<NPCEntityImpl> npcList = world.getEntitiesByClass(
//                            NPCEntityImpl.class,
//                            new Box(this.getX() + 8, this.getY() + 8, this.getZ() + 8,
//                                    this.getX() - 8, this.getY() - 8, this.getZ() - 8
//                            ),
//                            entity -> true)
//                    .stream()
//                    .filter(entity -> entity.getUuidAsString().equalsIgnoreCase(this.getUuidAsString()))
//                    .toList();
//            if(!npcList.isEmpty()) {
//                for (var npc: npcList) {
//                    if(npc.isSit()) continue;
//                    npc.setTarget((LivingEntity) attacker);
//                }
//            }
//        }
//    }
//
//    @Inject(method = "attack", at = @At("HEAD"), cancellable = true)
//    public void attack(Entity target, CallbackInfo ci) {
//        World world = this.getEntityWorld();
//        if (!target.isAttackable()) {
//            return;
//        }
//        if(!world.isClient()) {
//            List<NPCEntityImpl> npcList = world.getEntitiesByClass(
//                            NPCEntityImpl.class,
//                            new Box(this.getX() + 8, this.getY() + 8, this.getZ() + 8,
//                                    this.getX() - 8, this.getY() - 8, this.getZ() - 8
//                            ),
//                            entity -> true)
//                    .stream()
//                    .filter(entity -> entity.getUuidAsString().equalsIgnoreCase(this.getUuidAsString()))
//                    .toList();
//            if(!npcList.isEmpty()) {
//                for (var npc: npcList) {
//                    if(npc.isSit()) continue;
//                    npc.setTarget((LivingEntity) target);
//                }
//            }
//        }
//    }
}
