package cc.thonly.reverie_dreams.mixin.patches;

import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.Set;
import java.util.function.Consumer;

@Mixin(class_3283.class)
@Pseudo
@Slf4j
public class ResourcePackManagerMixin {
    @Shadow @Final private Set<class_3285> providers;

    @Redirect(
            method = "providePackProfiles",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/resource/ResourcePackProvider;register(Ljava/util/function/Consumer;)V"
            )
    )
    private void redirectRegister(class_3285 instance, Consumer<class_3288> consumer) {
        try {
            instance.method_14453(consumer);
        } catch (Exception e) {
            log.error("ResourcePackProvider register failed: ", e);
        }
    }
}
