package cc.thonly.reverie_dreams.mixin.server;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.interfaces.IDreamPillowManager;
import cc.thonly.reverie_dreams.item.armor.EarphoneItem;
import cc.thonly.reverie_dreams.server.DreamPillowManager;
import cc.thonly.reverie_dreams.server.player.PlayerDataComponentManager;
import com.mojang.datafixers.DataFixer;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3950;
import net.minecraft.class_5455;
import net.minecraft.class_6904;
import net.minecraft.class_7497;
import net.minecraft.server.MinecraftServer;
import nota.Nota;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.net.Proxy;
import java.util.function.BooleanSupplier;

@Slf4j
@Mixin(MinecraftServer.class)
public class MinecraftServerMixin implements IDreamPillowManager {
    @Unique
    private DreamPillowManager dreamPillowManager;

    @Inject(method = "<init>", at = @At("TAIL"))
    public void init(Thread serverThread, class_32.class_5143 session, class_3283 dataPackManager, class_6904 saveLoader, Proxy proxy, DataFixer dataFixer, class_7497 apiServices, class_3950 worldGenerationProgressListenerFactory, CallbackInfo ci) {
        MinecraftServer minecraftServer = (MinecraftServer) (Object) this;
        class_5455.class_6890 registryManager = minecraftServer.method_30611();
        Touhou.setServer(minecraftServer);
        Touhou.setDynamicRegistryManager(registryManager);
        PlayerDataComponentManager.getInstance().onLoad(minecraftServer);
        this.dreamPillowManager = new DreamPillowManager(minecraftServer);
        Nota.getAPI().server = minecraftServer;
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void onTickEnd(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        EarphoneItem.VEC_3_DS.clear();
    }

    @Unique
    @Override
    public DreamPillowManager getDreamPillowManager() {
        return this.dreamPillowManager;
    }

    @Unique
    @Override
    public void setDreamPillowManager(DreamPillowManager manager) {
        if (this.dreamPillowManager == null) {
            this.dreamPillowManager = manager;
        }
    }
}
