package cc.thonly.reverie_dreams.recipe.type;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_10130;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_9334;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;

@Slf4j
public class DanmakuRecipeType extends BaseRecipeType<DanmakuRecipe> {
    private static DanmakuRecipeType INSTANCE;

    public DanmakuRecipeType() {
        INSTANCE = this;
    }

    public static synchronized DanmakuRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        Map<class_2960, class_3298> resources = manager.method_14488((this.getTypeId() + "_recipe"), id -> {
            return id.method_12836().equals(Touhou.MOD_ID) && id.method_12832().endsWith(".json");
        });

        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 id = entry.getKey();
            class_2960 registryKey = class_2960.method_60655(id.method_12836(), id.method_12832().replaceFirst("^danmaku_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = entry.getValue();
            try (InputStream stream = resource.method_14482()) {
                JsonElement json = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, json);

                DataResult<DanmakuRecipe> result = this.getCodec().parse(input);

                result.resultOrPartial(error -> log.error("Failed to load danmaku recipe {}, {}", id, error))
                        .ifPresent(recipe -> {
                            this.add(registryKey, recipe);
                            class_1799 itemStack = recipe.getOutput().getItemStack();
                            itemStack.method_57379(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))));
                        });
            } catch (IOException e) {
                log.error("Failed to load danmaku recipe {}, {}, {}", id, e.getMessage(), e);
            }
        }
    }

    @Override
    public void bootstrap() {

    }

    @Override
    public List<DanmakuRecipe> getMatches(List<ItemStackWrapper> wrappers) {
        if (wrappers.size() < 5) {
            return List.of();
        }

        ItemStackWrapper dyeSlot = wrappers.get(0);
        ItemStackWrapper coreSlot = wrappers.get(1);
        ItemStackWrapper powerSlot = wrappers.get(2);
        ItemStackWrapper pointSlot = wrappers.get(3);
        ItemStackWrapper materialSlot = wrappers.get(4);

        List<DanmakuRecipe> matches = new ArrayList<>();
        for (DanmakuRecipe recipe : stream().toList()) {
//            System.out.println("Matching recipe: " + recipe);
//            System.out.println("input dyeSlot:      " + dyeSlot.getItemStack());
//            System.out.println("recipe.getDye():    " + recipe.getDye().getItemStack());
//            System.out.println("dye compare:        " + recipe.getDye().greaterThan(dyeSlot.getItemStack()));
//
//            System.out.println("core compare:       " + recipe.getCore().greaterThan(coreSlot.getItemStack()));
//            System.out.println("point compare:      " + recipe.getPoint().greaterThan(pointSlot.getItemStack()));
//            System.out.println("power compare:      " + recipe.getPower().greaterThan(powerSlot.getItemStack()));
//            System.out.println("material compare:   " + recipe.getMaterial().greaterThan(materialSlot.getItemStack()));
//            System.out.println("-----------------------------");
            if (
                    recipe.getDye().greaterThan(dyeSlot.getItemStack()) &&
                            recipe.getCore().greaterThan(coreSlot.getItemStack()) &&
                            recipe.getPoint().greaterThan(pointSlot.getItemStack()) &&
                            recipe.getPower().greaterThan(powerSlot.getItemStack()) &&
                            recipe.getMaterial().greaterThan(materialSlot.getItemStack())
            ) {
                matches.add(recipe);
            }
        }
        return matches;
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<DanmakuRecipe> getCodec() {
        return DanmakuRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "danmaku";
    }

    @Override
    public class_2960 getId() {
        return Touhou.id(this.getTypeId());
    }
}
