package cc.thonly.reverie_dreams.server.player;

import com.mojang.serialization.Codec;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PlayerComponentInitializer<T> {

    PlayerComponent<T> create(class_3222 player);

    default PlayerComponent<T> createAndLoad(class_3222 player) {
        Logger log = LoggerFactory.getLogger(PlayerComponentInitializer.class);
        PlayerComponent<T> playerComponent = this.create(player);
        playerComponent.setPlayer(player);
        try {
            playerComponent.onLoad();
        } catch (Exception err) {
            log.error("Can't load Player Data Component {}: {}", player.method_7334().getName(), player.method_5845());
        }
        return playerComponent;
    }

    Codec<T> getCodec();
}
