package cc.thonly.reverie_dreams.world.gen;

import cc.thonly.reverie_dreams.Touhou;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1992;
import net.minecraft.class_2246;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3754;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class DimensionInit {
    public static final class_5321<class_5363> DREAM_WORLD = getOrCreateRegistryKey("dream_world");
    public static final class_5321<class_5363> THE_MOON = getOrCreateRegistryKey("the_moon");

    public static void bootstrap(class_7891<class_5363> context) {
        var dimensionTypeLookup = context.method_46799(class_7924.field_41241);
        var biomeLookup = context.method_46799(class_7924.field_41236);
        var chunkGeneratorSettingsLookup = context.method_46799(class_7924.field_41243);

        var dreamWorldConfig = new class_3232(
                Optional.empty(),
                biomeLookup.method_46747(BiomeInit.DREAM),
                new ArrayList<>()
        );
        dreamWorldConfig.method_28911();
        dreamWorldConfig.method_28916();
        dreamWorldConfig.method_14327().add(new class_3229(4, class_2246.field_10499.method_9564().method_26204()));

        context.method_46838(DREAM_WORLD, new class_5363(
                dimensionTypeLookup.method_46747(DimensionTypeInit.DREAM_WORLD),
                new class_2897(
                        dreamWorldConfig
                )
        ));

        context.method_46838(THE_MOON, new class_5363(
                dimensionTypeLookup.method_46747(DimensionTypeInit.THE_MOON),
                new class_3754(
                        new class_1992(
                                biomeLookup.method_46747(BiomeInit.THE_MOON)
                        ),
                        chunkGeneratorSettingsLookup.method_46747(ChunkGeneratorSettingsInit.MOON)
                )
        ));
    }

    public static void init() {
    }

    public static class_5321<class_5363> getOrCreateRegistryKey(String name) {
        return class_5321.method_29179(class_7924.field_41224, class_2960.method_60655(Touhou.MOD_ID, name));
    }

}
