package cc.thonly.reverie_dreams.world.gen.feature;

import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.datagen.ModChestLootTableProvider;
import com.mojang.serialization.Codec;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class DreamTrialRoom extends class_3031<DreamTrialRoomConfig> {
    public DreamTrialRoom(Codec<DreamTrialRoomConfig> configCodec) {
        super(configCodec);
    }

    @Override
    public boolean method_13151(class_5821<DreamTrialRoomConfig> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        DreamTrialRoomConfig config = context.method_33656();

        int originX = context.method_33655().method_10263();
        int originY = context.method_33655().method_10264();
        int originZ = context.method_33655().method_10260();

        int sizeX = 16;
        int sizeY = 16;
        int sizeZ = 16;

        for (int x = 0; x < sizeX; x++) {
            for (int y = 0; y < sizeY; y++) {
                for (int z = 0; z < sizeZ; z++) {

                    boolean isEdge = x == 0 || x == sizeX - 1 ||
                            y == 0 || y == sizeY - 1 ||
                            z == 0 || z == sizeZ - 1;

                    int worldX = originX + x;
                    int worldY = originY + y;
                    int worldZ = originZ + z;
                    class_2338 blockPos = new class_2338(worldX, worldY, worldZ);
                    if (isEdge && world.method_8320(blockPos).method_26215()) {
                        // 放房间方块，例如梦境石
                        world.method_8652(
                                new class_2338(worldX, worldY, worldZ),
                                ModBlocks.DREAM_STONE_BRICK.block().method_9564(),
                                class_2248.field_31031
                        );
                    } else {
                        // 内部留空
                        continue;
                    }
                }
            }
        }

        // 放置刷怪笼在中心
        for (int i = 0; i < 2; i++) {
            int i1 = random.method_39332(1, 2 + i);
            class_2338 spawnerPos = new class_2338(
                    i1 + originX + sizeX / 2,
                    originY + 1,
                    i1 + originZ + sizeZ / 2
            );

            world.method_8652(spawnerPos,
                    class_2246.field_10260.method_9564(),
                    class_2248.field_31031
            );

            if (world.method_8321(spawnerPos) instanceof class_2636 spawner) {
                class_1299<?> entityType = class_7923.field_41177.method_63535(config.entityTypeId());
                spawner.method_11390().method_8274(entityType, null, random, spawnerPos);
            }
        }

        class_2338 boxPos = new class_2338(originX + sizeX / 2 + random.method_39332(1, 2), originY + 1, originZ + sizeZ / 2 + random.method_39332(1, 2));
        world.method_8652(boxPos,
                class_2246.field_10034.method_9564(),
                class_2248.field_31031);
        if (world.method_8321(boxPos) instanceof class_2595 chestBlockEntity) {
            chestBlockEntity.method_11285(ModChestLootTableProvider.DREAM_CHEST);
        }

        return true;
    }

}
