/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.mystias_izakaya.recipe.type;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.recipe.entry.KitchenRecipe;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitchenRecipeType
extends BaseRecipeType<KitchenRecipe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KitchenRecipeType.class);
    private static KitchenRecipeType INSTANCE;
    public final Map<KitchenType, Map<class_2960, KitchenRecipe>> kitchenRegistries = new Object2ObjectOpenHashMap();

    public KitchenRecipeType() {
        INSTANCE = this;
    }

    public static synchronized KitchenRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        this.kitchenRegistries.clear();
        Map resources = manager.method_14488(this.getTypeId() + "_recipe", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            class_2960 registryKey = class_2960.method_60655((String)id2.method_12836(), (String)id2.method_12832().replaceFirst("^kitchen_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = this.getCodec().parse(input);
                    result.resultOrPartial(error -> log.error("Failed to load kitchen recipe {}, {}", (Object)id2, error)).ifPresent(recipe -> this.add(registryKey, (KitchenRecipe)recipe));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to load kitchen recipe {}, {}, {}", new Object[]{id2, e.getMessage(), e});
            }
        }
    }

    @Override
    public BaseRecipeType<KitchenRecipe> add(class_2960 id, KitchenRecipe recipe) {
        super.add(id, recipe);
        this.register(recipe.getType(), id, recipe);
        return this;
    }

    public void register(KitchenType type, class_2960 key, KitchenRecipe recipe) {
        Map registry = this.kitchenRegistries.computeIfAbsent(type, R -> new Object2ObjectOpenHashMap());
        recipe.setId(key);
        registry.put(key, recipe);
    }

    public Map<class_2960, KitchenRecipe> getRecipeView(KitchenType type) {
        return Map.copyOf(this.kitchenRegistries.getOrDefault((Object)type, (Map<class_2960, KitchenRecipe>)new Object2ObjectOpenHashMap()));
    }

    @Override
    public void bootstrap() {
    }

    public List<KitchenRecipe> getMatches(KitchenType type, List<ItemStackWrapper> inputs) {
        ArrayList<KitchenRecipe> matches = new ArrayList<KitchenRecipe>();
        Map<class_2960, KitchenRecipe> registryView = this.getRecipeView(type);
        for (KitchenRecipe recipe : registryView.values()) {
            List<ItemStackWrapper> ingredients = recipe.getIngredients();
            boolean allMatched = ingredients.stream().allMatch(ingredient -> inputs.stream().anyMatch(input -> ingredient.greaterThan(input.getItemStack())));
            if (!allMatched) continue;
            matches.add(recipe);
        }
        return matches;
    }

    @Override
    public List<KitchenRecipe> getMatches(List<ItemStackWrapper> list) {
        return List.of();
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<KitchenRecipe> getCodec() {
        return KitchenRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "kitchen";
    }

    @Override
    public class_2960 getId() {
        return MystiasIzakaya.id(this.getTypeId());
    }

    public static enum KitchenType {
        COOKING_POT(MystiasIzakaya.id("cooking_pot")),
        CUTTING_BOARD(MystiasIzakaya.id("cutting_board")),
        FRYING_PAN(MystiasIzakaya.id("frying_pan")),
        GRILL(MystiasIzakaya.id("grill")),
        STREAMER(class_2960.method_60654((String)"streamer"));

        private static final Map<class_2960, KitchenType> SEARCH_CACHED;
        private final class_2960 id;

        private KitchenType(class_2960 id) {
            this.id = id;
        }

        public class_2960 toId() {
            return this.id;
        }

        public static KitchenType getFromId(class_2960 recipeId) {
            List<KitchenType> result;
            if (SEARCH_CACHED.containsKey(recipeId)) {
                SEARCH_CACHED.get(recipeId);
            }
            if ((result = Arrays.stream(KitchenType.values()).toList().stream().filter(recipeType -> recipeId.equals((Object)recipeType.id)).toList()).isEmpty()) {
                return null;
            }
            KitchenType first = result.getFirst();
            SEARCH_CACHED.put(recipeId, first);
            return first;
        }

        @Generated
        public class_2960 getId() {
            return this.id;
        }

        static {
            SEARCH_CACHED = new Object2ObjectOpenHashMap();
        }
    }
}

