/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer;

import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.factorytools.api.resourcepack.ModelModifiers;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.atlas.AtlasAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class ResourcePackGenerator {
    private static final Set<String> EXPANDABLE = Set.of("wall", "fence", "slab", "stairs", "pressure_plate", "button", "glass_pane", "lattice", "bars", "carpet", "chain", "lantern");

    public static void setup() {
        PolymerResourcePackUtils.RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT.register(ResourcePackGenerator::build);
    }

    private static void build(ResourcePackBuilder builder) {
        class_243 expansion = new class_243(0.08, 0.08, 0.08);
        AtlasAsset.Builder atlas = AtlasAsset.builder();
        builder.forEachFile((string, bytes) -> {
            for (String expandable : EXPANDABLE) {
                if (!string.contains(expandable) || !string.startsWith("assets/%s/models/block/".formatted("reverie_dreams"))) continue;
                ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                if (asset.parent().isPresent()) {
                    class_2960 parentId = (class_2960)asset.parent().get();
                    ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                    builder.addData(AssetPaths.model((String)"reverie_dreams_polymerify", (String)parentId.method_12832()) + ".json", new ModelAsset(parentAsset.parent(), parentAsset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), parentAsset.textures(), parentAsset.display(), parentAsset.guiLight(), parentAsset.ambientOcclusion()).toBytes());
                }
                if (!asset.elements().isPresent()) continue;
                builder.addData(string, new ModelAsset(asset.parent(), asset.elements().map(x -> x.stream().map(element -> new ModelElement(element.from().method_1020(expansion), element.to().method_1019(expansion), element.faces(), element.rotation(), element.shade(), element.lightEmission())).toList()), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
            }
        });
        for (Map.Entry entry : ((Map)BlockStateModelManager.UV_LOCKED_MODELS.get("reverie_dreams")).entrySet()) {
            class_243 expand = EXPANDABLE.stream().anyMatch(expandable -> ((String)entry.getKey()).contains((CharSequence)expandable) && ((String)entry.getKey()).startsWith("block/")) ? expansion : class_243.field_1353;
            for (StateModelVariant v : (List)entry.getValue()) {
                String suffix = "_uvlock_" + v.x() + "_" + v.y();
                class_2960 modelId = v.model().method_48331(suffix);
                ModelAsset asset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getData(AssetPaths.model((class_2960)v.model()) + ".json")), StandardCharsets.UTF_8));
                if (!asset.parent().isPresent()) continue;
                class_2960 parentId = (class_2960)asset.parent().get();
                ModelAsset parentAsset = ModelAsset.fromJson((String)new String(Objects.requireNonNull(builder.getDataOrSource(AssetPaths.model((class_2960)parentId) + ".json")), StandardCharsets.UTF_8));
                builder.addData(AssetPaths.model((String)"reverie_dreams_polymerify", (String)(parentId.method_12832() + suffix)) + ".json", (WritableAsset)ModelModifiers.expandModelAndRotateUVLocked((ModelAsset)parentAsset, (class_243)expand, (int)v.x(), (int)v.y()));
                builder.addData(AssetPaths.model((class_2960)modelId) + ".json", new ModelAsset(Optional.of(class_2960.method_60655((String)"reverie_dreams_polymerify", (String)(parentId.method_12832() + suffix))), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes());
            }
        }
        builder.addWriteConverter((string, bytes) -> {
            if (!string.contains("_uvlock_")) {
                for (String expandable : EXPANDABLE) {
                    if (!string.contains(expandable) || !string.startsWith("assets/%s/models/block/".formatted("reverie_dreams"))) continue;
                    ModelAsset asset = ModelAsset.fromJson((String)new String((byte[])bytes, StandardCharsets.UTF_8));
                    return new ModelAsset(asset.parent().map(x -> class_2960.method_60655((String)"reverie_dreams_polymerify", (String)x.method_12832())), asset.elements(), asset.textures(), asset.display(), asset.guiLight(), asset.ambientOcclusion()).toBytes();
                }
            }
            return bytes;
        });
        builder.addData("assets/minecraft/atlases/blocks.json", (WritableAsset)atlas.build());
    }
}

