/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.danmaku.script;

import cc.thonly.reverie_dreams.danmaku.script.DanmakuScriptNode;
import cc.thonly.reverie_dreams.entity.DanmakuScriptEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DanmakuScript {
    public static final List<RuntimeInstance> RUNTIME_INSTANCES = new ArrayList<RuntimeInstance>();
    public static final Codec<DanmakuScript> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max_tick").forGetter(DanmakuScript::getMaxTick), (App)Codec.list(DanmakuScriptNode.CODEC).fieldOf("nodes").forGetter(DanmakuScript::getNodes)).apply((Applicative)instance, DanmakuScript::new));
    private final int maxTick;
    private final List<DanmakuScriptNode> nodes = new ArrayList<DanmakuScriptNode>();

    private DanmakuScript() {
        this(100, new ArrayList<DanmakuScriptNode>());
    }

    public DanmakuScript(int maxTick, List<DanmakuScriptNode> nodes) {
        this.maxTick = maxTick;
        this.nodes.addAll(nodes);
    }

    public static void tick(MinecraftServer server) {
        for (RuntimeInstance runtimeInstance : RUNTIME_INSTANCES) {
            runtimeInstance.tick();
        }
    }

    public RuntimeInstance createRuntimeInstance(class_3218 world, double startX, double startY, double startZ) {
        RuntimeInstance runtimeInstance = new RuntimeInstance(world, startX, startY, startZ, this);
        RUNTIME_INSTANCES.add(runtimeInstance);
        return runtimeInstance;
    }

    @Generated
    public int getMaxTick() {
        return this.maxTick;
    }

    @Generated
    public List<DanmakuScriptNode> getNodes() {
        return this.nodes;
    }

    public static class RuntimeInstance {
        private final class_3218 world;
        private final double startX;
        private final double startY;
        private final double startZ;
        private final DanmakuScript script;
        private double x;
        private double y;
        private double z;
        private int tick = 0;
        private DanmakuScriptEntity entity;

        protected RuntimeInstance(class_3218 world, double startX, double startY, double startZ, DanmakuScript script) {
            this.world = world;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.x = startX;
            this.y = startY;
            this.z = startZ;
            this.script = script;
            this.init();
        }

        public void init() {
        }

        public void tick() {
            if (this.entity == null) {
                return;
            }
            List<DanmakuScriptNode> nodes = this.script.getNodes();
            for (DanmakuScriptNode node : nodes) {
                node.tick(this);
            }
            if (this.tick >= this.script.maxTick) {
                this.entity.method_31472();
                RUNTIME_INSTANCES.remove(this);
            } else {
                ++this.tick;
            }
        }

        @Generated
        public class_3218 getWorld() {
            return this.world;
        }

        @Generated
        public double getStartX() {
            return this.startX;
        }

        @Generated
        public double getStartY() {
            return this.startY;
        }

        @Generated
        public double getStartZ() {
            return this.startZ;
        }

        @Generated
        public DanmakuScript getScript() {
            return this.script;
        }

        @Generated
        public double getX() {
            return this.x;
        }

        @Generated
        public double getY() {
            return this.y;
        }

        @Generated
        public double getZ() {
            return this.z;
        }

        @Generated
        public int getTick() {
            return this.tick;
        }

        @Generated
        public DanmakuScriptEntity getEntity() {
            return this.entity;
        }

        @Generated
        public void setX(double x) {
            this.x = x;
        }

        @Generated
        public void setY(double y) {
            this.y = y;
        }

        @Generated
        public void setZ(double z) {
            this.z = z;
        }

        @Generated
        public void setTick(int tick) {
            this.tick = tick;
        }

        @Generated
        public void setEntity(DanmakuScriptEntity entity) {
            this.entity = entity;
        }
    }
}

