/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.danmaku.script;

import cc.thonly.reverie_dreams.danmaku.script.DanmakuScript;
import cc.thonly.reverie_dreams.danmaku.script.DanmakuScriptNodeCondition;
import cc.thonly.reverie_dreams.danmaku.script.DanmakuTask;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class DanmakuScriptNode {
    public static final Codec<DanmakuTask> TASK_CODEC = DanmakuTask.CODEC;
    public static final Codec<DanmakuScriptNodeCondition> CONDITION_CODEC = DanmakuScriptNodeCondition.CODEC;
    public static final Codec<DanmakuScriptNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(TASK_CODEC, (Codec)CONDITION_CODEC.listOf()).fieldOf("values").forGetter(DanmakuScriptNode::getTask2conditions)).apply((Applicative)instance, DanmakuScriptNode::new));
    private final Map<DanmakuTask, List<DanmakuScriptNodeCondition>> task2conditions;

    private DanmakuScriptNode() {
        this((Map<DanmakuTask, List<DanmakuScriptNodeCondition>>)new Object2ObjectOpenHashMap());
    }

    public DanmakuScriptNode(Map<DanmakuTask, List<DanmakuScriptNodeCondition>> task2conditions) {
        this.task2conditions = new Object2ObjectOpenHashMap(task2conditions);
    }

    public void tick(DanmakuScript.RuntimeInstance runtimeInstance) {
        for (Map.Entry<DanmakuTask, List<DanmakuScriptNodeCondition>> entry : this.task2conditions.entrySet()) {
            DanmakuTask task = entry.getKey();
            List<DanmakuScriptNodeCondition> conditions = entry.getValue();
            boolean allPassed = true;
            for (DanmakuScriptNodeCondition condition : conditions) {
                boolean test = condition.test(runtimeInstance.getTick());
                if (test || !allPassed) continue;
                allPassed = false;
            }
            if (!allPassed) continue;
            task.runTask();
        }
    }

    @Generated
    public Map<DanmakuTask, List<DanmakuScriptNodeCondition>> getTask2conditions() {
        return this.task2conditions;
    }
}

