/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.danmaku.script;

import com.mojang.serialization.Codec;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanmakuScriptNodeCondition {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DanmakuScriptNodeCondition.class);
    public static final Codec<DanmakuScriptNodeCondition> CODEC = Codec.STRING.xmap(DanmakuScriptNodeCondition::new, DanmakuScriptNodeCondition::getSource);
    private final String source;
    @Nullable
    private final CompiledScript expression;

    private DanmakuScriptNodeCondition(String source) {
        this.source = source;
        this.expression = this.tryCompile(source);
    }

    public boolean test(int tick) {
        if (this.expression == null) {
            log.warn("Expression is null for source: {}", (Object)this.source);
            return false;
        }
        try {
            Bindings bindings = this.expression.getEngine().createBindings();
            bindings.put("tick", (Object)tick);
            Object result = this.expression.eval(bindings);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).doubleValue() != 0.0;
            }
            return false;
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public CompiledScript tryCompile(String str) {
        try {
            return this.compileOrThrow(str);
        }
        catch (Exception err) {
            log.error("Can't compile str {}", (Object)str, (Object)err);
            return null;
        }
    }

    public CompiledScript compileOrThrow(String str) {
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
            String expr = str.replace("${{tick}}", "tick");
            if (!(engine instanceof Compilable)) {
                throw new UnsupportedOperationException("Engine does not support compile");
            }
            Compilable compilable = (Compilable)((Object)engine);
            return compilable.compile(expr);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Compile failed: " + str, e);
        }
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Nullable
    @Generated
    public CompiledScript getExpression() {
        return this.expression;
    }
}

