/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.misc;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.damage.DanmakuDamageType;
import cc.thonly.reverie_dreams.entity.FriendlyFaction;
import cc.thonly.reverie_dreams.entity.ModEntities;
import cc.thonly.reverie_dreams.entity.misc.BypassHitEntity;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DanmakuEntity
extends class_1665 {
    public static final class_2940<Float> ROLL = class_2945.method_12791(DanmakuEntity.class, (class_2941)class_2943.field_13320);
    public static final int MAX_FLIGHT_TICK = 400;
    protected class_1792 danmakuItem;
    protected class_1799 itemStack = class_1802.field_8543.method_7854();
    protected Float scale;
    protected Boolean tile = false;
    protected DanmakuDamageType danmakuDamageType;
    protected Float acceleration = Float.valueOf(0.0f);
    protected OnHitFactory onHitEffect;
    private final float setupPitch;
    private final float setupYaw;
    private double damage;
    public int flyAge;
    protected int fluidAge;
    protected int fightTick;
    protected int particleTick;

    public DanmakuEntity(@Nullable class_1297 livingEntity2, class_3218 world, Double x, Double y, Double z, class_1799 stack, Float pitch, Float yaw, Float speed, Float acceleration, Float divergence, Float offsetDist) {
        super(ModEntities.DANMAKU_ENTITY_TYPE, x.doubleValue(), y + (double)(livingEntity2 != null ? livingEntity2.method_5751() : 0.0f), z.doubleValue(), (class_1937)world, stack.method_7972(), stack.method_7972());
        this.onHitEffect = (livingEntity, damage) -> {};
        this.flyAge = 0;
        this.fluidAge = 0;
        this.fightTick = 0;
        this.particleTick = 0;
        this.setupPitch = pitch.floatValue();
        this.setupYaw = yaw.floatValue();
        double offsetX = -Math.sin(Math.toRadians(yaw.floatValue())) * (double)offsetDist.floatValue();
        double offsetZ = Math.cos(Math.toRadians(yaw.floatValue())) * (double)offsetDist.floatValue();
        double newX = x + offsetX;
        double newY = y + (double)(livingEntity2 != null ? livingEntity2.method_5751() : 0.0f);
        double newZ = z + offsetZ;
        this.method_23327(newX, newY, newZ);
        this.acceleration = acceleration;
        this.method_7432(livingEntity2);
        if (livingEntity2 != null) {
            this.method_24919(livingEntity2, pitch.floatValue(), yaw.floatValue(), 0.0f, speed.floatValue(), divergence.floatValue());
        } else {
            this.method_24919((class_1297)this, pitch.floatValue(), yaw.floatValue(), 0.0f, speed.floatValue(), divergence.floatValue());
        }
        this.method_36456(yaw.floatValue());
        this.method_36457(pitch.floatValue());
        this.field_7572 = class_1665.class_1666.field_7594;
        this.method_7438((double)((Float)stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE, (Object)Float.valueOf(1.0f))).floatValue() * 1.5);
        this.setScale(Float.valueOf(((Float)stack.method_58695(ModDataComponentTypes.Danmaku.SCALE, (Object)Float.valueOf(1.0f))).floatValue() * 0.65f));
        String type = (String)stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE_TYPE, (Object)Touhou.id("generic").toString());
        this.setTile((Boolean)stack.method_58695(ModDataComponentTypes.Danmaku.TILE, (Object)false));
        this.setDanmakuDamageType(RegistryManager.DANMAKU_DAMAGE_TYPE.method_63535(class_2960.method_60654((String)type)));
        this.setCustomPierceLevel((byte)1);
        this.setItemStack(stack.method_7972());
        this.setDanmakuItem(stack.method_7909());
        this.method_5875(true);
    }

    public DanmakuEntity(class_1299<DanmakuEntity> danmakuEntityEntityType, class_1937 world) {
        super(danmakuEntityEntityType, world);
        this.onHitEffect = (livingEntity, damage) -> {};
        this.flyAge = 0;
        this.fluidAge = 0;
        this.fightTick = 0;
        this.particleTick = 0;
        this.setDanmakuItem(null);
        this.scale = Float.valueOf(1.0f);
        this.setupPitch = 0.0f;
        this.setupYaw = 0.0f;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ROLL, (Object)Float.valueOf(0.0f));
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.itemStack.method_7960()) {
            view.method_71468("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC, (Object)this.itemStack.method_7972());
        }
        view.method_71472("IsTile", this.tile.booleanValue());
        class_2960 danmakuDamageTypeId = RegistryManager.DANMAKU_DAMAGE_TYPE.method_10221(this.danmakuDamageType);
        if (danmakuDamageTypeId != null) {
            view.method_71469("DamageType", danmakuDamageTypeId.toString());
        }
        view.method_71465("FlyAge", this.flyAge);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.itemStack = view.method_71426("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC).orElse(class_1799.field_8037);
        this.tile = view.method_71433("IsTile", true);
        this.danmakuDamageType = RegistryManager.DANMAKU_DAMAGE_TYPE.method_63535(class_2960.method_60654((String)view.method_71428("DamageType", Touhou.id("generic").toString())));
        this.flyAge = view.method_71424("FlyAge", 0);
    }

    public void method_5773() {
        super.method_5773();
        ++this.fightTick;
        ++this.particleTick;
        if (!this.method_65059()) {
            this.field_6011.method_12778(ROLL, (Object)Float.valueOf((float)((double)((Float)this.field_6011.method_12789(ROLL)).floatValue() - 0.01745329238474369 * this.method_18798().method_1027() * 15.0) % ((float)Math.PI * 2)));
        }
        this.method_36457(this.setupPitch);
        this.method_36456(this.setupYaw);
        if (this.particleTick > 2) {
            class_1937 world = this.method_37908();
            if (!world.method_8608() && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                serverWorld.method_65096((class_2394)class_2398.field_28013, this.method_19538().field_1352, this.method_19538().field_1351, this.method_19538().field_1350, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.particleTick = 0;
        }
        if (this.method_5799()) {
            ++this.fluidAge;
            if (this.fluidAge > 80) {
                this.method_31472();
            }
        }
        if (this.fightTick > 400) {
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        this.method_33574(blockHitResult.method_17784());
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2680 block = this.method_37908().method_8320(blockHitResult.method_17777());
            this.blockHitParticles(this.method_19538(), block, this.method_37908(), this.getDamage() * this.method_18798().method_1033());
            class_3414 soundEvent = block.method_26231().method_10596();
            this.method_5803(false);
            this.method_5783(soundEvent, 0.2f, 1.0f);
            this.method_5803(true);
        }
        this.method_33572(true);
        super.method_24920(blockHitResult);
        this.method_33572(false);
        this.method_31472();
    }

    protected boolean canDamage(class_1297 entity, class_1297 owner) {
        if (entity instanceof BypassHitEntity) {
            return false;
        }
        if (owner == entity) {
            return false;
        }
        if (owner instanceof FriendlyFaction) {
            FriendlyFaction ownerFaction = (FriendlyFaction)owner;
            if (entity instanceof FriendlyFaction) {
                FriendlyFaction entityFaction = (FriendlyFaction)entity;
                return !ownerFaction.getFactionId().equals(entityFaction.getFactionId());
            }
        }
        return true;
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1657 player;
        class_1297 owner;
        class_1297 entity = entityHitResult.method_17782();
        if (!this.canDamage(entity, owner = this.method_24921())) {
            return;
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_6039()) {
            boolean isInAttackRange = false;
            class_1799 activeItem = player.method_6030();
            if (!activeItem.method_7960()) {
                class_10707 blocksAttacksComponent = (class_10707)activeItem.method_58694(class_9334.field_56396);
                if (blocksAttacksComponent != null) {
                    List damageReductions = blocksAttacksComponent.comp_3588();
                    for (class_10707.class_10708 damageReduction : damageReductions) {
                        class_243 toProj2D;
                        float blockingAngle = damageReduction.comp_3638();
                        class_243 toProjectile = this.method_19538().method_1020(player.method_33571()).method_1029();
                        class_243 playerLook = player.method_5828(1.0f);
                        class_243 look2D = new class_243(playerLook.field_1352, 0.0, playerLook.field_1350).method_1029();
                        double dot = class_3532.method_15350((double)look2D.method_1026(toProj2D = new class_243(toProjectile.field_1352, 0.0, toProjectile.field_1350).method_1029()), (double)-1.0, (double)1.0);
                        double angle = Math.toDegrees(Math.acos(dot));
                        if (!(angle <= (double)(blockingAngle / 2.0f + 5.0f))) continue;
                        isInAttackRange = true;
                        break;
                    }
                }
                if (isInAttackRange) {
                    activeItem.method_61653(1, player);
                    this.method_31472();
                    return;
                }
            }
        }
        this.method_33574(entityHitResult.method_17784());
        this.method_5803(false);
        this.method_5803(true);
        if (entityHitResult.method_17782() != null) {
            this.method_7438(this.getDamage());
            this.entityHitParticles(entityHitResult.method_17782(), this.getDamage() * this.method_18798().method_1033());
        }
        this.hitDamage(entityHitResult, this.method_37908());
        this.method_31472();
    }

    protected void hitDamage(class_3966 entityHitResult, class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_1297 target = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                if (this.method_24921() != entityHitResult.method_17782()) {
                    class_1282 damageSource;
                    if (owner instanceof class_1309) {
                        class_1309 attacker = (class_1309)owner;
                        damageSource = world.method_48963().method_48800((class_1297)this, attacker);
                    } else {
                        damageSource = this.danmakuDamageType.mapToSource(world.method_48963());
                    }
                    float damageAmount = (float)this.getDamage();
                    livingTarget.method_64397(serverWorld, damageSource, damageAmount);
                    livingTarget.method_5684(false);
                    livingTarget.field_6253 = 0.0f;
                    this.onHitEffect.damage(livingTarget, this.getDamage());
                }
            }
        }
    }

    protected void entityHitParticles(class_1297 livingEntity, double damage) {
        class_1937 class_19372 = livingEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_243 pos = livingEntity.method_19538();
            int particleCount = (int)damage * 4;
            double radius = (double)(livingEntity.method_17681() / 2.0f) + 0.5;
            double heightOffset = livingEntity.method_17682();
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                class_2392 itemStackParticleEffect = new class_2392(class_2398.field_11218, this.method_57314());
                world.method_65096((class_2394)itemStackParticleEffect, pos.field_1352, pos.field_1351, pos.field_1350, 1, xOffset, heightOffset / (double)particleCount * (double)i, zOffset, 0.25);
            }
        }
    }

    protected void blockHitParticles(class_243 pos, class_2680 blockState, class_1937 worldTemp, double damage) {
        if (worldTemp instanceof class_3218) {
            class_3218 world = (class_3218)worldTemp;
            int particleCount = (int)damage * 4;
            double radius = 1.0;
            double heightOffset = 1.0;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 / (double)particleCount * (double)i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);
                class_2388 blockStateParticleEffect = new class_2388(class_2398.field_11217, blockState);
                world.method_65096((class_2394)blockStateParticleEffect, pos.field_1352, pos.field_1351, pos.field_1350, 1, xOffset, heightOffset / (double)particleCount * (double)i, zOffset, 0.25);
            }
        }
    }

    public void setCustomPierceLevel(byte level) {
        if (!this.tryInvokeMethod(class_1665.class, "setPierceLevel", Byte.TYPE, level)) {
            this.tryInvokeMethod(class_1665.class, "method_7451", Byte.TYPE, level);
        }
    }

    private boolean tryInvokeMethod(Class<?> targetClass, String methodName, Class<?> paramType, Object paramValue) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke((Object)this, paramValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected class_1799 method_57314() {
        if (this.danmakuItem != null && !this.danmakuItem.method_7854().method_7960()) {
            return this.danmakuItem.method_7854();
        }
        return new class_1799((class_1935)ModItems.ICON);
    }

    @Generated
    public void setDanmakuItem(class_1792 danmakuItem) {
        this.danmakuItem = danmakuItem;
    }

    @Generated
    public void setItemStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Generated
    public void setScale(Float scale) {
        this.scale = scale;
    }

    @Generated
    public void setTile(Boolean tile) {
        this.tile = tile;
    }

    @Generated
    public void setDanmakuDamageType(DanmakuDamageType danmakuDamageType) {
        this.danmakuDamageType = danmakuDamageType;
    }

    @Generated
    public void setAcceleration(Float acceleration) {
        this.acceleration = acceleration;
    }

    @Generated
    public void setOnHitEffect(OnHitFactory onHitEffect) {
        this.onHitEffect = onHitEffect;
    }

    @Generated
    public void method_7438(double damage) {
        this.damage = damage;
    }

    @Generated
    public void setFlyAge(int flyAge) {
        this.flyAge = flyAge;
    }

    @Generated
    public void setFluidAge(int fluidAge) {
        this.fluidAge = fluidAge;
    }

    @Generated
    public void setFightTick(int fightTick) {
        this.fightTick = fightTick;
    }

    @Generated
    public void setParticleTick(int particleTick) {
        this.particleTick = particleTick;
    }

    @Generated
    public class_1792 getDanmakuItem() {
        return this.danmakuItem;
    }

    @Generated
    public class_1799 method_54759() {
        return this.itemStack;
    }

    @Generated
    public Float getScale() {
        return this.scale;
    }

    @Generated
    public Boolean getTile() {
        return this.tile;
    }

    @Generated
    public DanmakuDamageType getDanmakuDamageType() {
        return this.danmakuDamageType;
    }

    @Generated
    public Float getAcceleration() {
        return this.acceleration;
    }

    @Generated
    public OnHitFactory getOnHitEffect() {
        return this.onHitEffect;
    }

    @Generated
    public float getSetupPitch() {
        return this.setupPitch;
    }

    @Generated
    public float getSetupYaw() {
        return this.setupYaw;
    }

    @Generated
    public double getDamage() {
        return this.damage;
    }

    @Generated
    public int getFlyAge() {
        return this.flyAge;
    }

    @Generated
    public int getFluidAge() {
        return this.fluidAge;
    }

    @Generated
    public int getFightTick() {
        return this.fightTick;
    }

    @Generated
    public int getParticleTick() {
        return this.particleTick;
    }

    @Generated
    public String toString() {
        return "DanmakuEntity(danmakuItem=" + String.valueOf(this.getDanmakuItem()) + ", itemStack=" + String.valueOf(this.method_54759()) + ", scale=" + this.getScale() + ", tile=" + this.getTile() + ", danmakuDamageType=" + String.valueOf(this.getDanmakuDamageType()) + ", acceleration=" + this.getAcceleration() + ", onHitEffect=" + String.valueOf(this.getOnHitEffect()) + ", setupPitch=" + this.getSetupPitch() + ", setupYaw=" + this.getSetupYaw() + ", damage=" + this.getDamage() + ", flyAge=" + this.getFlyAge() + ", fluidAge=" + this.getFluidAge() + ", fightTick=" + this.getFightTick() + ", particleTick=" + this.getParticleTick() + ")";
    }

    public static interface OnHitFactory {
        public void damage(class_1309 var1, double var2);
    }
}

