/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.skin;

import cc.thonly.reverie_dreams.entity.skin.NPCSkin;
import cc.thonly.reverie_dreams.entity.skin.NPCSkinConfig;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPCSkinConfigs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NPCSkinConfigs.class);

    public static void bootstrap(IntrinsicalRegister<NPCSkinConfig> registry) {
    }

    public static void reload(class_3300 manager) {
        Iterator<NPCSkin> iterator = RegistryManager.ROLE_SKIN.iterator();
        while (iterator.hasNext()) {
            NPCSkin skin = iterator.next();
            skin.setConfig(new NPCSkinConfig(NPCSkinConfig.ModelType.SLIM, Optional.empty(), Optional.empty()));
        }
        Map resources = manager.method_14488("skin_config", id -> id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 resourceId = (class_2960)entry.getKey();
            class_2960 key = class_2960.method_60655((String)resourceId.method_12836(), (String)resourceId.method_12832().replace("skin_config/", "").replace(".json", ""));
            class_3298 resource = (class_3298)entry.getValue();
            NPCSkin skin = RegistryManager.ROLE_SKIN.method_63535(key);
            if (skin == null) {
                log.warn("Unknown skin id: {}", (Object)resourceId);
                continue;
            }
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = NPCSkinConfig.CODEC.parse(input);
                    result.resultOrPartial(error -> log.warn("Failed to parse Skin Config for {}: {}", (Object)resourceId, error)).ifPresent(data -> {
                        skin.setConfig((NPCSkinConfig)data);
                        RegistryManager.register(RegistryManager.SKIN_CONFIG, key, data);
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to load Skin Config {}: {}", new Object[]{resourceId, e.getMessage(), e});
            }
        }
    }
}

