/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.mixin.entity;

import cc.thonly.reverie_dreams.effect.ModStatusEffects;
import cc.thonly.reverie_dreams.entity.GhostEntity;
import cc.thonly.reverie_dreams.entity.ai.goal.GhostStatusEffectTargetGoal;
import cc.thonly.reverie_dreams.interfaces.IPlayerEntity;
import cc.thonly.reverie_dreams.server.DelayedTask;
import cc.thonly.reverie_dreams.world.GameRulesInit;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IPlayerEntity {
    @Unique
    private static final long MAX_NON_SLEEPING_TIME = 12000L;
    @Unique
    private long nonSleepingTime = 0L;
    @Unique
    private boolean sleep = false;
    @Unique
    private static final class_6880<class_1291> MENTAL_DISORDER = ModStatusEffects.MENTAL_DISORDER;

    @Shadow
    public abstract boolean method_56992();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.nonSleepingTick();
        if (this.method_6113()) {
            if (this.method_6059(MENTAL_DISORDER)) {
                this.method_6016(MENTAL_DISORDER);
            }
            this.nonSleepingTime = 0L;
            this.sleep = true;
        } else {
            this.sleep = false;
        }
    }

    @Unique
    public void nonSleepingTick() {
        if (this.method_56992()) {
            return;
        }
        MinecraftServer server = this.method_5682();
        class_1937 world = this.method_37908();
        if (server == null) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (GhostStatusEffectTargetGoal.hasSilverArmor(this)) {
                this.nonSleepingTime = 0L;
                return;
            }
            if (this.nonSleepingTime < 12000L) {
                ++this.nonSleepingTime;
            } else if (serverWorld.method_64395().method_8355(GameRulesInit.DO_GHOST)) {
                this.trySpawnGhost();
                this.method_6092(new class_1293(ModStatusEffects.MENTAL_DISORDER, 6000));
                DelayedTask.whenTick(server, () -> this.sleep, 2400.0f, this::trySpawnGhost, () -> {});
                this.nonSleepingTime = 0L;
            }
        }
    }

    @Unique
    private void trySpawnGhost() {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        class_1937 world = this.method_37908();
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        boolean value = serverWorld.method_64395().method_8355(GameRulesInit.DO_GHOST);
        if (!value) {
            return;
        }
        if (world.equals(server.method_30002())) {
            class_2338 origin = this.method_24515();
            class_2338 a = this.getRandomPos(origin);
            class_2338 b = this.getRandomPos(origin);
            GhostEntity aMob = new GhostEntity(world);
            aMob.method_23327(a.method_10263(), a.method_10264(), a.method_10260());
            GhostEntity bMob = new GhostEntity(world);
            bMob.method_23327(b.method_10263(), b.method_10264(), b.method_10260());
            serverWorld.method_8649((class_1297)aMob);
            serverWorld.method_8649((class_1297)bMob);
        }
    }

    @Unique
    private class_2338 getRandomPos(class_2338 origin) {
        class_1937 world = this.method_37908();
        class_5819 random = world.method_8409();
        int offsetX = random.method_43048(11) - 5;
        int offsetZ = random.method_43048(11) - 5;
        int surfaceY = world.method_8624(class_2902.class_2903.field_13202, origin.method_10263() + offsetX, origin.method_10260() + offsetZ);
        return new class_2338(origin.method_10263() + offsetX, surfaceY, origin.method_10260() + offsetZ);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    protected void writeCustomData(class_11372 view, CallbackInfo ci) {
        super.method_5652(view);
        view.method_71466("NonSleepingTime", this.nonSleepingTime);
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    protected void readCustomData(class_11368 view, CallbackInfo ci) {
        super.method_5749(view);
        this.nonSleepingTime = view.method_71425("NonSleepingTime", 0L);
    }

    @Override
    @Unique
    public void setNonSleepingTime(long time) {
        this.nonSleepingTime = time;
    }

    @Override
    @Unique
    public long getNonSleepingTime() {
        return this.nonSleepingTime;
    }
}

