/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe.type;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.class_10130;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanmakuRecipeType
extends BaseRecipeType<DanmakuRecipe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DanmakuRecipeType.class);
    private static DanmakuRecipeType INSTANCE;

    public DanmakuRecipeType() {
        INSTANCE = this;
    }

    public static synchronized DanmakuRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        Map resources = manager.method_14488(this.getTypeId() + "_recipe", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            class_2960 registryKey = class_2960.method_60655((String)id2.method_12836(), (String)id2.method_12832().replaceFirst("^danmaku_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = this.getCodec().parse(input);
                    result.resultOrPartial(error -> log.error("Failed to load danmaku recipe {}, {}", (Object)id2, error)).ifPresent(recipe -> {
                        this.add(registryKey, recipe);
                        class_1799 itemStack = recipe.getOutput().getItemStack();
                        itemStack.method_57379(class_9334.field_53966, (Object)new class_10130(0.5f, Optional.of(class_2960.method_60654((String)UUID.randomUUID().toString()))));
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to load danmaku recipe {}, {}, {}", new Object[]{id2, e.getMessage(), e});
            }
        }
    }

    @Override
    public void bootstrap() {
    }

    @Override
    public List<DanmakuRecipe> getMatches(List<ItemStackWrapper> wrappers) {
        if (wrappers.size() < 5) {
            return List.of();
        }
        ItemStackWrapper dyeSlot = wrappers.get(0);
        ItemStackWrapper coreSlot = wrappers.get(1);
        ItemStackWrapper powerSlot = wrappers.get(2);
        ItemStackWrapper pointSlot = wrappers.get(3);
        ItemStackWrapper materialSlot = wrappers.get(4);
        ArrayList<DanmakuRecipe> matches = new ArrayList<DanmakuRecipe>();
        for (DanmakuRecipe recipe : this.stream().toList()) {
            if (!recipe.getDye().greaterThan(dyeSlot.getItemStack()).booleanValue() || !recipe.getCore().greaterThan(coreSlot.getItemStack()).booleanValue() || !recipe.getPoint().greaterThan(pointSlot.getItemStack()).booleanValue() || !recipe.getPower().greaterThan(powerSlot.getItemStack()).booleanValue() || !recipe.getMaterial().greaterThan(materialSlot.getItemStack()).booleanValue()) continue;
            matches.add(recipe);
        }
        return matches;
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<DanmakuRecipe> getCodec() {
        return DanmakuRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "danmaku";
    }

    @Override
    public class_2960 getId() {
        return Touhou.id(this.getTypeId());
    }
}

