/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe.type;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3902;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanmakuShapeDrawRecipeType
extends BaseRecipeType<DanmakuShapeDrawRecipe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DanmakuShapeDrawRecipeType.class);
    private static DanmakuShapeDrawRecipeType INSTANCE;

    public DanmakuShapeDrawRecipeType() {
        INSTANCE = this;
    }

    public static synchronized DanmakuShapeDrawRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        Map resources = manager.method_14488(this.getTypeId() + "_recipe", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            class_2960 registryKey = class_2960.method_60655((String)id2.method_12836(), (String)id2.method_12832().replaceFirst("^danmaku_shape_draw_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = this.getCodec().parse(input);
                    result.resultOrPartial(error -> log.error("Failed to load danmaku shape draw recipe {}, {}", (Object)id2, error)).ifPresent(recipe -> this.add(registryKey, recipe));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to load danmaku shape draw recipe {}, {}, {}", new Object[]{id2, e.getMessage(), e});
            }
        }
        this.loadPreset();
    }

    private void loadPreset() {
    }

    @Override
    public void bootstrap() {
    }

    public List<DanmakuShapeDrawRecipe> getMatches(List<List<Boolean>> input, class_3902 unit) {
        ArrayList<DanmakuShapeDrawRecipe> matches = new ArrayList<DanmakuShapeDrawRecipe>();
        for (DanmakuShapeDrawRecipe recipe : this.stream().toList()) {
            List<List<Boolean>> shape = recipe.getShape();
            if (input.size() != shape.size()) continue;
            boolean matched = true;
            for (int y = 0; y < shape.size(); ++y) {
                List<Boolean> rowShape = shape.get(y);
                List<Boolean> rowInput = input.get(y);
                if (rowInput.size() != rowShape.size()) {
                    matched = false;
                    break;
                }
                for (int x = 0; x < rowShape.size(); ++x) {
                    if (rowShape.get(x).equals(rowInput.get(x))) continue;
                    matched = false;
                    break;
                }
                if (!matched) break;
            }
            if (!matched) continue;
            matches.add(recipe);
            return matches;
        }
        return matches;
    }

    public List<List<List<Boolean>>> getShapesByOutput(ItemStackWrapper output) {
        ArrayList<List<List<Boolean>>> results = new ArrayList<List<List<Boolean>>>();
        for (DanmakuShapeDrawRecipe recipe : this.stream().toList()) {
            ItemStackWrapper outputWrapper = recipe.getOutput();
            class_1799 itemStack = outputWrapper.getItemStack();
            ItemStackWrapper itemStackWrapper = (ItemStackWrapper)itemStack.method_58694(ModDataComponentTypes.Danmaku.SHAPE);
            if (itemStackWrapper == null || !itemStackWrapper.equals(output)) continue;
            results.add(recipe.getShape());
        }
        return results;
    }

    @Override
    public List<DanmakuShapeDrawRecipe> getMatches(List<ItemStackWrapper> wrappers) {
        return List.of();
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<DanmakuShapeDrawRecipe> getCodec() {
        return DanmakuShapeDrawRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "danmaku_shape_draw";
    }

    @Override
    public class_2960 getId() {
        return Touhou.id(this.getTypeId());
    }
}

