/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DreamPillowManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DreamPillowManager.class);
    public static final Codec<List<WorldEntry>> CODEC = Codec.list(WorldEntry.CODEC);
    private static final Gson GSON = new Gson();
    private static DreamPillowManager INSTANCE;
    private final MinecraftServer server;
    private final Path savedPath;
    private final Map<class_1937, WorldEntry> data;

    public DreamPillowManager(MinecraftServer server) {
        this.server = server;
        this.savedPath = server.method_27050(class_5218.field_24188).resolve("data/dream_pillow.json");
        this.data = new Object2ObjectOpenHashMap();
        INSTANCE = this;
    }

    public void init() {
        for (class_3218 world : this.server.method_3738()) {
            WorldEntry worldEntry = new WorldEntry((class_5321<class_1937>)world.method_27983(), new ArrayList<class_2338>());
            worldEntry.setWorld(world);
            this.data.put((class_1937)world, worldEntry);
        }
        this.load();
    }

    public WorldEntry get(class_3218 world) {
        return this.data.get(world);
    }

    public void load() {
        try {
            Files.createDirectories(this.savedPath.getParent(), new FileAttribute[0]);
        }
        catch (Exception err) {
            log.error("Can't create dir", (Throwable)err);
        }
        if (Files.exists(this.savedPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.savedPath, StandardCharsets.UTF_8);){
                JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                Optional optional = result.result();
                if (optional.isPresent()) {
                    block9: for (WorldEntry worldEntry : (List)optional.get()) {
                        for (Map.Entry<class_1937, WorldEntry> managerEntry : this.data.entrySet()) {
                            WorldEntry value = managerEntry.getValue();
                            if (!value.registryKey.equals(worldEntry.registryKey)) continue;
                            value.loadData(worldEntry.signLocations);
                            continue block9;
                        }
                    }
                }
            }
            catch (IOException ioException) {
                log.error("Can't load dream pillow data", (Throwable)ioException);
            }
        }
    }

    public void save() {
        block8: {
            try {
                Files.createDirectories(this.savedPath.getParent(), new FileAttribute[0]);
                List<WorldEntry> values = this.data.values().stream().toList();
                DataResult result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, values);
                Optional optional = result.result();
                if (!optional.isPresent()) break block8;
                JsonElement element = (JsonElement)optional.get();
                String json = GSON.toJson(element);
                try (BufferedWriter writer = Files.newBufferedWriter(this.savedPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                    writer.write(json);
                }
            }
            catch (IOException ioException) {
                log.error("Can't save dream pillow data", (Throwable)ioException);
            }
        }
    }

    public static Optional<DreamPillowManager> getInstance() {
        return Optional.ofNullable(INSTANCE);
    }

    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }

    @Generated
    public Path getSavedPath() {
        return this.savedPath;
    }

    @Generated
    public Map<class_1937, WorldEntry> getData() {
        return this.data;
    }

    public static class WorldEntry {
        public static final Codec<WorldEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("world").forGetter(WorldEntry::getRegistryKey), (App)Codec.list((Codec)class_2338.field_25064).fieldOf("sign_locations").forGetter(WorldEntry::getSignLocations)).apply((Applicative)instance, WorldEntry::new));
        private class_5321<class_1937> registryKey;
        private class_3218 world;
        private final List<class_2338> signLocations;

        public WorldEntry(class_5321<class_1937> registryKey, Collection<class_2338> signLocations) {
            this.registryKey = registryKey;
            this.signLocations = new ArrayList<class_2338>((Collection<class_2338>)new ObjectOpenHashSet(signLocations));
        }

        public void add(class_2338 pos) {
            this.signLocations.add(pos);
        }

        public boolean contains(class_2338 pos) {
            if (pos == null) {
                return false;
            }
            Set collect = this.signLocations.stream().filter(Objects::nonNull).map(class_2338::method_10063).collect(Collectors.toSet());
            return this.signLocations.contains(pos) || !collect.isEmpty() && collect.contains(pos.method_10063());
        }

        public void remove(class_2338 pos) {
            long target = pos.method_10063();
            this.signLocations.removeIf(p -> p.method_10063() == target);
        }

        public void loadData(List<class_2338> signLocations) {
            ObjectOpenHashSet merged = new ObjectOpenHashSet(this.signLocations);
            merged.addAll(signLocations);
            this.signLocations.clear();
            this.signLocations.addAll((Collection<class_2338>)merged);
        }

        public void setWorld(class_3218 world) {
            if (this.world == null) {
                this.registryKey = world.method_27983();
                this.world = world;
            }
        }

        @Generated
        public class_5321<class_1937> getRegistryKey() {
            return this.registryKey;
        }

        @Generated
        public class_3218 getWorld() {
            return this.world;
        }

        @Generated
        public List<class_2338> getSignLocations() {
            return this.signLocations;
        }
    }
}

