/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class ItemTagManager {
    private static final ItemTagManager INSTANCE = new ItemTagManager();
    private final Map<class_6862<class_1792>, Set<class_1792>> SET_MAP = new Object2ObjectLinkedOpenHashMap();
    private final Map<class_1792, Set<class_6862<class_1792>>> ITEM_2_TAG_KEY = new Object2ObjectLinkedOpenHashMap();

    private ItemTagManager() {
    }

    public void clearTags() {
        this.SET_MAP.clear();
        this.ITEM_2_TAG_KEY.clear();
    }

    public void load(MinecraftServer server) {
        this.clearTags();
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378 registry = registryManager.method_30530(class_7924.field_41197);
        Stream namedStream = registry.method_40272();
        for (class_6885.class_6888 registryEntries : namedStream.toList()) {
            class_6862 tag = registryEntries.method_40251();
            Set items = this.SET_MAP.computeIfAbsent((class_6862<class_1792>)tag, tagKey -> new LinkedHashSet());
            List entries = registryEntries.field_36460;
            if (entries == null) continue;
            for (class_6880 itemRegistryEntry : entries.stream().toList()) {
                class_1792 item = (class_1792)itemRegistryEntry.comp_349();
                Set tagKeys = this.ITEM_2_TAG_KEY.computeIfAbsent(item, i -> new HashSet());
                tagKeys.add(tag);
            }
            Set collect = entries.stream().map(class_6880::comp_349).collect(Collectors.toSet());
            items.addAll(collect);
        }
    }

    public boolean isEmpty() {
        return this.SET_MAP.isEmpty() || this.ITEM_2_TAG_KEY.isEmpty();
    }

    public boolean contains(class_6862<class_1792> tagKey, class_1792 item) {
        return this.ITEM_2_TAG_KEY.getOrDefault(item, Set.of()).contains(tagKey);
    }

    public Set<class_6862<class_1792>> getTakKey(class_1792 item) {
        return this.ITEM_2_TAG_KEY.getOrDefault(item, Set.of());
    }

    public static ItemTagManager getInstance() {
        return INSTANCE;
    }
}

