/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.server;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class ParticleTickerManager {
    private static final List<Entry> ENTRIES = new LinkedList<Entry>();

    public static synchronized void joinQueue(class_3218 world, class_2394 particleEffect, int count, class_243 from, class_243 to, float durationSeconds) {
        ENTRIES.add(new Entry(world.method_8503(), world, from, to, durationSeconds * 20.0f, Present.LINEAR, particleEffect, count));
    }

    public static synchronized void joinQueue(class_3218 world, class_2394 particleEffect, int count, class_243 from, class_243 to, Present present, float durationSeconds) {
        ENTRIES.add(new Entry(world.method_8503(), world, from, to, durationSeconds * 20.0f, present, particleEffect, count));
    }

    public static synchronized void tick(MinecraftServer server) {
        Iterator<Entry> iterator = ENTRIES.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getServer() != server) {
                iterator.remove();
                continue;
            }
            if (entry.hasNext()) {
                class_243 pos = entry.next();
                class_2394 particleType = entry.getParticleType();
                class_3324 playerManager = server.method_3760();
                class_3218 world = entry.getWorld();
                world.method_65096(particleType, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.1);
                continue;
            }
            iterator.remove();
        }
    }

    public static class Entry {
        private final MinecraftServer server;
        private final class_3218 world;
        private final class_243 start;
        private final class_243 end;
        private final double maxStep;
        private final Present present;
        private final class_2394 particleType;
        private final int count;
        private double currentStep = 0.0;

        public Entry(MinecraftServer server, class_3218 world, class_243 start, class_243 end, double maxStep, class_2394 particleType, int count) {
            this(server, world, start, end, maxStep, Present.LINEAR, particleType, count);
        }

        public Entry(MinecraftServer server, class_3218 world, class_243 start, class_243 end, double maxStep, Present present, class_2394 particleType, int count) {
            this.server = server;
            this.world = world;
            this.start = start;
            this.end = end;
            this.maxStep = maxStep;
            this.present = present;
            this.particleType = particleType;
            this.count = count;
        }

        public boolean hasNext() {
            if (this.currentStep > this.maxStep) {
                return false;
            }
            this.currentStep += 1.0;
            return true;
        }

        public class_243 next() {
            double t = this.currentStep / this.maxStep;
            this.currentStep += 1.0;
            return this.present.instance.getVec(t, this.start, this.end);
        }

        @Generated
        public MinecraftServer getServer() {
            return this.server;
        }

        @Generated
        public class_3218 getWorld() {
            return this.world;
        }

        @Generated
        public class_243 getStart() {
            return this.start;
        }

        @Generated
        public class_243 getEnd() {
            return this.end;
        }

        @Generated
        public double getMaxStep() {
            return this.maxStep;
        }

        @Generated
        public Present getPresent() {
            return this.present;
        }

        @Generated
        public class_2394 getParticleType() {
            return this.particleType;
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public double getCurrentStep() {
            return this.currentStep;
        }
    }

    public static enum Present {
        LINEAR(new PathInstance(t -> t, t -> t, t -> t)),
        PARABOLA(new PathInstance(t -> t, t -> 4.0 * t * (1.0 - t), t -> t)),
        SINE_WAVE(new PathInstance(t -> t, t -> Math.sin(t * Math.PI * 2.0) * 0.5 + 0.5, t -> t)),
        ZIGZAG(new PathInstance(t -> t, t -> (int)(t * 10.0) % 2 == 0 ? 0.2 : 0.8, t -> t)),
        EASE_IN_OUT_CUBIC(new PathInstance(t -> t, t -> t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0, t -> t)),
        BOUNCE_OUT(new PathInstance(t -> t, t -> {
            double n1 = 7.5625;
            double d1 = 2.75;
            if (t < 0.36363636363636365) {
                return 7.5625 * t * t;
            }
            if (t < 0.7272727272727273) {
                return 7.5625 * (t -= 0.5454545454545454) * t + 0.75;
            }
            if (t < 0.9090909090909091) {
                return 7.5625 * (t -= 0.8181818181818182) * t + 0.9375;
            }
            return 7.5625 * (t -= 0.9545454545454546) * t + 0.984375;
        }, t -> t)),
        ELASTIC_OUT(new PathInstance(t -> t, t -> {
            double c4 = 2.0943951023931953;
            return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * t) * Math.sin((t * 10.0 - 0.75) * 2.0943951023931953) + 1.0);
        }, t -> t)),
        BACK_OUT(new PathInstance(t -> t, t -> {
            double c1 = 1.70158;
            double c3 = 2.70158;
            return 1.0 + 2.70158 * Math.pow(t - 1.0, 3.0) + 1.70158 * Math.pow(t - 1.0, 2.0);
        }, t -> t));

        public final PathInstance instance;

        private Present(PathInstance instance) {
            this.instance = instance;
        }
    }

    @FunctionalInterface
    public static interface LinePath {
        public double get(double var1);
    }

    public record PathInstance(LinePath x, LinePath y, LinePath z) {
        public class_243 getVec(double t, class_243 from, class_243 to) {
            return new class_243(this.x.get(t) * (to.field_1352 - from.field_1352) + from.field_1352, this.y.get(t) * (to.field_1351 - from.field_1351) + from.field_1351, this.z.get(t) * (to.field_1350 - from.field_1350) + from.field_1350);
        }
    }
}

