/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer.block;

import cc.thonly.polymer.block.model.TransparentFlatTripWire;
import cc.thonly.polymer.block.model.TransparentPlantWatterlogged;
import cc.thonly.reverie_dreams.block.CropBlockCreator;
import cc.thonly.reverie_dreams.block.base.AbstractCropBlock;
import cc.thonly.reverie_dreams.util.block.CropAgeModelProvider;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3737;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class CropBlockImpl
implements PolymerTexturedBlock,
FactoryBlock {
    private final AbstractCropBlock block;

    public CropBlockImpl(AbstractCropBlock block) {
        this.block = block;
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10293.method_9564();
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        if (state.method_26204() instanceof class_3737) {
            return TransparentPlantWatterlogged.TRANSPARENT_WATTERLOGGED;
        }
        return TransparentFlatTripWire.TRANSPARENT_FLAT_TRIPIWIRE;
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState, this.block.getMaxAge());
    }

    public static class Model
    extends BlockModel {
        private static final Map<AbstractCropBlock, class_1799[]> MODELS = new Object2ObjectOpenHashMap();
        private final class_3218 world;
        private final class_2338 blockPos;
        private final class_2680 blockState;
        private final AbstractCropBlock block;
        private final Integer maxAge;
        private final class_1799[] models;
        private boolean isNormal = false;
        public ItemDisplayElement main;

        public Model(class_3218 world, class_2338 blockPos, class_2680 blockState, Integer maxAge) {
            this.world = world;
            this.blockPos = blockPos;
            this.blockState = blockState;
            this.maxAge = maxAge;
            class_2248 block = blockState.method_26204();
            Optional<CropBlockCreator.Instance> instanceOptional = CropBlockCreator.getInstance(block);
            boolean isPresent = instanceOptional.isPresent();
            if (isPresent && block instanceof AbstractCropBlock) {
                AbstractCropBlock cropBlock = (AbstractCropBlock)block;
                CropBlockCreator.Instance instance = instanceOptional.get();
                this.block = (AbstractCropBlock)blockState.method_26204();
                this.models = MODELS.computeIfAbsent(cropBlock, x -> new class_1799[this.maxAge.intValue()]);
                class_2960 identifier = instance.getIdentifier();
                String namespace = identifier.method_12836();
                String path = identifier.method_12832();
                for (int i = 0; i < this.maxAge; ++i) {
                    class_2960 modelId = class_2960.method_60655((String)namespace, (String)("block/" + path + "_stage" + i));
                    this.models[i] = ItemDisplayElementUtil.getModel((class_2960)modelId);
                }
                this.isNormal = true;
                this.init(blockState);
            } else {
                this.block = null;
                this.models = MODELS.computeIfAbsent(null, x -> new class_1799[1]);
            }
        }

        public void init(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple();
            this.updateItem(state);
            this.main.setScale((Vector3fc)new Vector3f(1.0f));
            this.addElement((VirtualElement)this.main);
        }

        protected void updateItem(class_2680 state) {
            int age = (Integer)state.method_11654((class_2769)this.block.getAgeProperty());
            CropAgeModelProvider modelProvider = this.block.getModelProvider();
            this.main.setItem(modelProvider.get(this.models, age));
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (this.isNormal && updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateItem(this.blockState());
                this.tick();
            }
            super.notifyUpdate(updateType);
        }

        public class_1799[] getModels() {
            return MODELS.get(this.block);
        }

        @Generated
        public class_3218 getWorld() {
            return this.world;
        }

        @Generated
        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        @Generated
        public class_2680 getBlockState() {
            return this.blockState;
        }

        @Generated
        public AbstractCropBlock getBlock() {
            return this.block;
        }

        @Generated
        public Integer getMaxAge() {
            return this.maxAge;
        }

        @Generated
        public boolean isNormal() {
            return this.isNormal;
        }

        @Generated
        public ItemDisplayElement getMain() {
            return this.main;
        }
    }
}

