/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.command;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.command.CommandInit;
import cc.thonly.reverie_dreams.debug.DebugExportWriter;
import cc.thonly.reverie_dreams.dialog.DialogFiles;
import cc.thonly.reverie_dreams.dialog.DialogInit;
import cc.thonly.reverie_dreams.dialog.DialogPlayer;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeCategoryGui;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.registry.Translatable;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import cc.thonly.reverie_dreams.util.ImageToTextScanner;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_11419;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainCommand
implements CommandInit.CommandRegistration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainCommand.class);

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"touhou");
        LiteralArgumentBuilder help = (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(this::help);
        LiteralArgumentBuilder recipe = (LiteralArgumentBuilder)class_2170.method_9247((String)"recipe").executes(this::recipe);
        LiteralArgumentBuilder registry = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"registry").requires(source -> source.method_9259(2))).then(RegistryManager.getSuggestProvider((Command<class_2168>)((Command)this::registry)));
        LiteralArgumentBuilder dialog = (LiteralArgumentBuilder)class_2170.method_9247((String)"dialog").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new DialogSuggestionProvider()).executes(this::dialog));
        LiteralArgumentBuilder video = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"video").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"play").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new DialogFiles.FilesSuggestionProvider()).executes(this::playVideo)).then(class_2170.method_9244((String)"sound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10934)).executes(this::playVideo)))))).then(class_2170.method_9247((String)"reload").executes(this::reloadVideo));
        LiteralArgumentBuilder about = (LiteralArgumentBuilder)class_2170.method_9247((String)"about").executes(this::about);
        root.executes(this::run);
        root.then((ArgumentBuilder)help);
        root.then((ArgumentBuilder)recipe);
        root.then((ArgumentBuilder)registry);
        root.then((ArgumentBuilder)dialog);
        root.then((ArgumentBuilder)video);
        root.then((ArgumentBuilder)about);
        dispatcher.register(root);
    }

    private int run(CommandContext<class_2168> context) {
        class_5250 text = class_2561.method_43471((String)"command.touhou.suggest_help");
        ((class_2168)context.getSource()).method_9226(() -> text.method_10862(class_2583.field_24360.method_10977(class_124.field_1054)), false);
        return 1;
    }

    private int registry(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_2960 registryKeyId = class_2232.method_9443(context, (String)"registry_key");
        class_2960 id = class_2232.method_9443(context, (String)"id");
        if (registryKeyId == null || id == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid identifier format."));
            return 0;
        }
        class_5321 registryKey = class_5321.method_29180((class_2960)registryKeyId);
        IntrinsicalRegister<?> registry = RegistryManager.ROOT.get(registryKey);
        if (registry == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Registry not found: ").method_10852((class_2561)class_2561.method_43470((String)registryKey.toString())));
            return 0;
        }
        Object value = registry.method_63535(id);
        class_5250 msg = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"=== ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)class_5321.method_29179((class_5321)registryKey, (class_2960)id).toString()).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" ===\n").method_27692(class_124.field_1065));
        if (value == null) {
            msg.method_10852((class_2561)class_2561.method_43470((String)"No entry found for this ID.").method_27692(class_124.field_1061));
            source.method_45068((class_2561)msg);
            return 0;
        }
        if (value instanceof Translatable) {
            Translatable translatable = (Translatable)value;
            msg.method_10852((class_2561)class_2561.method_43470((String)"Translation: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)translatable.translateKey()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        msg.method_10852((class_2561)class_2561.method_43470((String)"Object: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(class_124.field_1075));
        source.method_45068((class_2561)msg);
        return 1;
    }

    private int reloadVideo(CommandContext<class_2168> context) {
        DialogFiles.reload();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.touhou.video.reload"), false);
        return 1;
    }

    private int playVideo(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, (String)"target");
            String file = StringArgumentType.getString(context, (String)"file");
            class_2960 soundEventId = null;
            class_3414 soundEvent = null;
            try {
                soundEventId = class_2232.method_9443(context, (String)"sound");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (soundEventId != null) {
                soundEvent = class_3414.method_47908((class_2960)soundEventId);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.touhou.video.reload"), false);
            DialogPlayer.play(player, file, soundEvent);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.touhou.video.load.done"), false);
        }
        catch (Exception err) {
            log.error("Can't play video", (Throwable)err);
        }
        return 1;
    }

    private int help(CommandContext<class_2168> context) {
        List<String> keys = List.of("command.touhou.help.title", "command.touhou.help.help", "command.touhou.help.recipe", "command.touhou.help.about", "command.touhou.help.empty");
        for (String key : keys) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)key).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)), false);
        }
        return 1;
    }

    private int dialog(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            return 0;
        }
        class_3222 player = source.method_44023();
        String value = StringArgumentType.getString(context, (String)"value");
        class_11419 dialog = DialogInit.ARGS_DIALOG.get(value);
        if (player != null && dialog != null) {
            player.method_71753(class_6880.method_40223((Object)dialog));
        }
        return 1;
    }

    private int exportRegistries(CommandContext<class_2168> context) {
        LinkedList<CallSite> lines = new LinkedList<CallSite>();
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_5455.class_6890 registryManager = server.method_30611();
        Stream entryStream = registryManager.method_40311();
        List list = entryStream.toList();
        for (class_5455.class_6892 entry : list) {
            class_5321 class_53212 = entry.comp_350();
            class_2378 registry = entry.comp_351();
            lines.add((CallSite)((Object)("===== Registry: " + String.valueOf(class_53212.method_29177()) + " =====")));
            registry.forEach(obj -> {
                int rawId = registry.method_10206(obj);
                class_2960 id = registry.method_10221(obj);
                if (rawId == 97) {
                    lines.add((CallSite)((Object)("!!! Found 97 in " + String.valueOf(key.method_29177()) + " = " + String.valueOf(id))));
                }
            });
        }
        DebugExportWriter output = DebugExportWriter.OUTPUT;
        for (String string : lines) {
            output.write(string, new Object[0]);
        }
        output.export();
        return 1;
    }

    private int about(CommandContext<class_2168> context) {
        Class<Touhou> clazz = Touhou.class;
        ImageToTextScanner instance = ImageToTextScanner.createInstance(clazz);
        String path = ImageToTextScanner.ofNamespace("reverie_dreams", "icon_about.png");
        BufferedImage iconBuffer = instance.loadImageFromJar(path);
        List<class_2561> iconText = instance.renderImageToText(iconBuffer, 16, 16);
        String[] infoKeys = new String[]{"command.touhou.about.line1", "command.touhou.about.line2", "command.touhou.about.line3", "command.touhou.about.line4", "command.touhou.about.line5", "command.touhou.about.line6", "command.touhou.about.title", "command.touhou.about.version", "command.touhou.about.author", "command.touhou.about.line10", "command.touhou.about.line11"};
        ArrayList<class_5250> rightTexts = new ArrayList<class_5250>();
        for (String key : infoKeys) {
            if (key.equals("command.touhou.about.version")) {
                rightTexts.add(class_2561.method_43469((String)key, (Object[])new Object[]{ConstantInfo.VERSION}));
                continue;
            }
            rightTexts.add(class_2561.method_43471((String)key));
        }
        while (rightTexts.size() < iconText.size()) {
            rightTexts.add(class_2561.method_43470((String)""));
        }
        for (int i = 0; i < iconText.size(); ++i) {
            class_2561 left = iconText.get(i);
            class_5250 right = ((class_2561)rightTexts.get(i)).method_27661().method_27692(class_124.field_1068);
            ((class_2168)context.getSource()).method_9226(() -> MainCommand.lambda$about$8(left, (class_2561)right), false);
        }
        return 1;
    }

    private int recipe(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player != null) {
            RecipeTypeCategoryGui.create(player);
        }
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$about$8(class_2561 left, class_2561 right) {
        return class_2561.method_43473().method_10852(left).method_10852((class_2561)class_2561.method_43470((String)"  ")).method_10852(right);
    }

    public static class DialogSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            for (String string : DialogInit.ARGS_DIALOG.keySet()) {
                builder.suggest(string);
            }
            return builder.buildFuture();
        }
    }
}

