/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualZipFS
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VirtualZipFS.class);
    private final ZipFile zip;
    private final Map<String, FileEntry> files = new LinkedHashMap<String, FileEntry>();

    public VirtualZipFS(ZipFile zip) {
        this.zip = zip;
        this.load();
    }

    public static VirtualZipFS open(Path path) throws IOException {
        return new VirtualZipFS(new ZipFile(path.toFile()));
    }

    public byte[] getBytes(String path) {
        FileEntry entry = this.files.get(path = VirtualZipFS.normalize(path));
        if (entry == null) {
            log.warn("File not found in virtual zip: {}", (Object)path);
            return new byte[0];
        }
        return entry.data();
    }

    public String getString(String path) {
        return new String(this.getBytes(path), StandardCharsets.UTF_8);
    }

    public FileEntry get(String path) {
        return this.files.get(VirtualZipFS.normalize(path));
    }

    public List<String> list(String path) {
        if (!((String)(path = VirtualZipFS.normalize((String)path))).endsWith("/")) {
            path = (String)path + "/";
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.files.keySet()) {
            if (!name.startsWith((String)path)) continue;
            result.add(name);
        }
        return result;
    }

    public boolean exists(String path) {
        return this.files.containsKey(VirtualZipFS.normalize(path));
    }

    private void load() {
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String fullName = VirtualZipFS.normalize(entry.getName());
            String filename = VirtualZipFS.extractFileName(fullName);
            String extension = VirtualZipFS.extractExtension(fullName);
            try {
                InputStream in = this.zip.getInputStream(entry);
                try {
                    byte[] data = in.readAllBytes();
                    this.files.put(fullName, new FileEntry(filename, extension, data));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception err) {
                log.error("Failed to load entry {} from zip: {}", (Object)fullName, (Object)err.toString());
            }
        }
        log.info("Loaded virtual zip with {} files", (Object)this.files.size());
    }

    private static String extractFileName(String fullPath) {
        int slash = fullPath.lastIndexOf(47);
        return slash >= 0 ? fullPath.substring(slash + 1) : fullPath;
    }

    private static String extractExtension(String fullPath) {
        String name = VirtualZipFS.extractFileName(fullPath);
        int dot = name.lastIndexOf(46);
        return dot >= 0 ? name.substring(dot + 1).toLowerCase(Locale.ROOT) : "";
    }

    private static String normalize(String path) {
        return path.replace('\\', '/');
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
        this.files.clear();
    }

    public record FileEntry(String filename, String extension, byte[] data) {
    }
}

