/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.datagen.entry.SoundEventBuilder;
import cc.thonly.reverie_dreams.datagen.generator.DataGeneratorUtil;
import cc.thonly.reverie_dreams.sound.JukeBoxEntry;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoundProvider
implements class_2405 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoundProvider.class);
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, SoundEventBuilder> identifierSoundEventMap = new Object2ObjectOpenHashMap();

    public SoundProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    public SoundProvider add(class_2960 id, SoundEventBuilder entry) {
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public SoundProvider addWithSoundEvent(class_3414 soundEvent, @Nullable String soundPath) {
        class_2960 id = soundEvent.comp_3319();
        SoundEventBuilder entry = new SoundEventBuilder(id);
        entry.setSubtitle(id);
        if (soundPath != null) {
            entry.addSounds(soundPath);
        } else {
            entry.addSounds(id.toString());
        }
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public SoundProvider addWithRecords(JukeBoxEntry jukeBoxEntry, @Nullable String soundPath) {
        class_9793 ref = jukeBoxEntry.getRef();
        class_2960 id = ((class_3414)ref.comp_2835().comp_349()).comp_3319();
        SoundEventBuilder entry = new SoundEventBuilder(id);
        entry.setSubtitle(id);
        if (soundPath != null) {
            entry.addSoundsByName(soundPath);
        } else {
            entry.addSoundsByName(id.method_12836() + ":records/" + id.method_12832());
        }
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public abstract void configured();

    public void export(class_7403 writer) {
        try {
            String namespace;
            Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR, new String[0]);
            LinkedHashMap<String, List> namespaceToBuild = new LinkedHashMap<String, List>();
            for (Map.Entry<class_2960, SoundEventBuilder> entry : this.identifierSoundEventMap.entrySet()) {
                namespace = entry.getKey().method_12836();
                SoundEventBuilder ref = entry.getValue();
                List list = namespaceToBuild.computeIfAbsent(namespace, k -> new LinkedList());
                list.add(ref);
            }
            for (Map.Entry<Object, SoundEventBuilder> entry : namespaceToBuild.entrySet()) {
                namespace = (String)entry.getKey();
                Path generatePath = DataGeneratorUtil.getAssetsByNullable(path, namespace, null, null);
                Path output = generatePath.resolve("sounds.json");
                Files.createDirectories(generatePath, new FileAttribute[0]);
                List list = (List)((Object)entry.getValue());
                JsonObject object = new JsonObject();
                for (SoundEventBuilder builder : list) {
                    class_2960 key = builder.getKey();
                    JsonElement element = builder.toJsonElement();
                    object.add(key.method_12832(), element);
                }
                String jsonString = this.gson.toJson((JsonElement)object);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                writer.method_43346(output, bytes, HashCode.fromBytes((byte[])bytes));
            }
        }
        catch (Exception err) {
            log.error("Can't export sounds.json: ", (Throwable)err);
        }
    }

    public String method_10321() {
        return "Sounds JSON Provider";
    }
}

