/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.npc;

import cc.thonly.mystias_izakaya.item.base.DrinkItem;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCInteractResult;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleInteractionEvent;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleMessage;
import cc.thonly.reverie_dreams.gui.NPCGui;
import cc.thonly.reverie_dreams.interfaces.IItemStack;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_10131;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPCRoleInteractionEvents {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NPCRoleInteractionEvents.class);
    public static final List<NPCRoleMessage> MESSAGES = new ArrayList<NPCRoleMessage>();
    public static final NPCRoleInteractionEvent MESSAGE;
    public static final NPCRoleInteractionEvent ON_OPEN_INVENTORY;
    public static final NPCRoleInteractionEvent ON_UPGRADED_HEALTH;
    public static final NPCRoleInteractionEvent ON_TAME;
    public static final NPCRoleInteractionEvent ON_FEED_POTIONS;
    public static final NPCRoleInteractionEvent ON_FEED_FOOD;
    public static final NPCRoleInteractionEvent SET_OWNER_BY_STICk;

    public static void bootstrap(IntrinsicalRegister<NPCRoleInteractionEvent> registry) {
    }

    public static class_1269 emit(class_3218 world, class_3222 player, class_1268 hand, NPCRoleEntity entity) {
        class_1799 itemStack = player.method_5998(hand);
        Iterator<NPCRoleInteractionEvent> iterator = RegistryManager.ROLE_INTERACTION_EVENT.iterator();
        while (iterator.hasNext()) {
            NPCRoleInteractionEvent event = iterator.next();
            int i = 0;
            Enum interact = null;
            try {
                ++i;
                interact = event.interact(world, player, itemStack, hand, entity);
                if (interact == NPCInteractResult.PASS) continue;
                return switch (2.$SwitchMap$cc$thonly$reverie_dreams$entity$npc$NPCInteractResult[interact.ordinal()]) {
                    case 1 -> class_1269.field_52422;
                    case 2 -> class_1269.field_5814;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(interact));
                };
            }
            catch (Exception err) {
                log.error("Role Interaction event {} triggering failed", interact != null ? interact.name() : Integer.valueOf(i), (Object)err);
            }
        }
        return class_1269.field_21466;
    }

    public static NPCRoleMessage registerMessage(final class_5250 mutableText) {
        NPCRoleMessage npcRoleMessage = new NPCRoleMessage(){

            @Override
            @NotNull
            public class_5250 getMessage(class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) {
                return mutableText;
            }

            @Override
            public class_2960 getId() {
                return Touhou.id("message/%s".formatted(MESSAGES.size()));
            }
        };
        MESSAGES.add(npcRoleMessage);
        return npcRoleMessage;
    }

    public static NPCRoleMessage registerMessage(NPCRoleMessage message) {
        MESSAGES.add(message);
        return message;
    }

    public static NPCRoleInteractionEvent registerEvent(String name, NPCRoleInteractionEvent.InteractionCallback callback) {
        return NPCRoleInteractionEvents.registerEvent(Touhou.id(name), callback);
    }

    public static NPCRoleInteractionEvent registerEvent(class_2960 eventId, NPCRoleInteractionEvent.InteractionCallback callback) {
        NPCRoleInteractionEvent event = new NPCRoleInteractionEvent(callback);
        return RegistryManager.registerForBuiltin(RegistryManager.ROLE_INTERACTION_EVENT, eventId, event);
    }

    static {
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.0"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.1"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.2"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.3"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.4"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.5"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.6"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.7"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.8"));
        NPCRoleInteractionEvents.registerMessage(class_2561.method_43471((String)"npc.event.send_message.9"));
        MESSAGE = NPCRoleInteractionEvents.registerEvent("message", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (stack.method_7960() && !player.method_5715() && entity.method_6181()) {
                if (MESSAGES.isEmpty()) {
                    return NPCInteractResult.PASS;
                }
                class_5819 random = class_5819.method_43047();
                NPCRoleMessage npcRoleMessage = MESSAGES.get(random.method_39332(0, MESSAGES.size() - 1));
                class_5250 message = npcRoleMessage.getMessage(world, player, stack, hand, entity);
                class_5250 body = class_2561.method_43473();
                body.method_10852(entity.method_5477());
                body.method_27693(": ");
                body.method_10852((class_2561)message);
                Optional.ofNullable(npcRoleMessage.getSoundEvent()).ifPresent(soundEvent -> world.method_54762(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), soundEvent, class_3419.field_15251));
                player.method_7353((class_2561)body, false);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        ON_OPEN_INVENTORY = NPCRoleInteractionEvents.registerEvent("on_open_inventory", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (stack.method_7960() && entity.isAllowOpenInventory(player) && player.method_5715()) {
                NPCGui npcGui = new NPCGui(player, entity);
                npcGui.open();
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        ON_UPGRADED_HEALTH = NPCRoleInteractionEvents.registerEvent("on_upgraded_health", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (!entity.method_6171((class_1309)player)) {
                return NPCInteractResult.PASS;
            }
            if (stack.method_7909() == ModItems.UPGRADED_HEALTH) {
                class_5131 attributes = entity.method_6127();
                class_1324 max_health = attributes.method_45329(class_5134.field_23716);
                float health = entity.method_6032();
                float maxHealth = entity.method_6063();
                if (max_health != null) {
                    max_health.method_6192((double)(maxHealth + 2.0f));
                    entity.method_6033(health + 2.0f);
                }
                player.method_6104(hand);
                player.method_5783(SoundEventInit.UP, 1.0f, 1.0f);
                stack.method_57008(1, (class_1309)player);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        ON_TAME = NPCRoleInteractionEvents.registerEvent("on_tame", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (entity.npcOwner.isEmpty() && stack.method_31573(ModTags.ItemTypeTag.ROLE_TAME_FOOD)) {
                class_5819 random = class_5819.method_43047();
                float chance = random.method_43057();
                if ((double)chance <= 0.4) {
                    entity.method_6174((class_1309)player);
                    entity.method_6173(true, true);
                    world.method_65096((class_2394)class_2398.field_11201, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
                }
                entity.method_6033(entity.method_6032() + 5.0f);
                stack.method_57008(1, (class_1309)player);
                player.method_6104(hand);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        ON_FEED_POTIONS = NPCRoleInteractionEvents.registerEvent("on_feed_potions", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            block7: {
                block8: {
                    if (!entity.method_6171((class_1309)player)) {
                        return NPCInteractResult.PASS;
                    }
                    if (stack.method_7960()) {
                        return NPCInteractResult.PASS;
                    }
                    if (!entity.canFeed().booleanValue()) break block7;
                    if (stack.method_7909() == class_1802.field_8574) break block8;
                    class_1792 patt0$temp = stack.method_7909();
                    if (!(patt0$temp instanceof DrinkItem)) break block7;
                    DrinkItem drinkItem = (DrinkItem)patt0$temp;
                }
                class_10131 useRemainderComponent = (class_10131)stack.method_58694(class_9334.field_53965);
                entity.method_5783((class_3414)class_3417.field_20613.comp_349(), 1.0f, 1.0f);
                class_1799 result = stack.method_7910((class_1937)world, (class_1309)entity);
                if (!player.method_56992()) {
                    player.method_6122(hand, result);
                }
                if (useRemainderComponent != null && !player.method_56992()) {
                    class_1799 itemStack = useRemainderComponent.method_62863(stack, stack.method_7947(), player.method_56992(), arg_0 -> ((class_3222)player).method_64399(arg_0));
                    player.method_6122(hand, itemStack);
                }
                player.method_6104(hand);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        ON_FEED_FOOD = NPCRoleInteractionEvents.registerEvent("_feed_food", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (!entity.method_6171((class_1309)player)) {
                return NPCInteractResult.PASS;
            }
            if (stack.method_7960()) {
                return NPCInteractResult.PASS;
            }
            if ((((IItemStack)stack).isFood() || stack.method_31573(ModTags.ItemTypeTag.ROLE_TAME_FOOD)) && entity.canFeed().booleanValue()) {
                entity.method_5783((class_3414)class_3417.field_20614.comp_349(), 1.0f, 1.0f);
                class_1799 result = stack.method_7910((class_1937)world, (class_1309)entity);
                if (!player.method_56992()) {
                    player.method_6122(hand, result);
                }
                player.method_6104(hand);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
        SET_OWNER_BY_STICk = NPCRoleInteractionEvents.registerEvent("set_owner_by_stick", (class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) -> {
            if (stack.method_7909() == ModItems.OWNER_STICK) {
                entity.method_6174((class_1309)player);
                return NPCInteractResult.SUCCESS;
            }
            return NPCInteractResult.PASS;
        });
    }
}

