/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.mixin.entity;

import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.effect.ModStatusEffects;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.interfaces.IBedBlockEntity;
import cc.thonly.reverie_dreams.interfaces.ILivingEntity;
import cc.thonly.reverie_dreams.interfaces.IWorld;
import cc.thonly.reverie_dreams.item.armor.DreamArmorItem;
import cc.thonly.reverie_dreams.item.prop.DreamPillowItem;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2587;
import net.minecraft.class_2709;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ILivingEntity {
    @Shadow
    public float field_6241;
    @Unique
    public double manpozuchiUsingState = 1.0;
    @Unique
    public float maxHealthModifier = 0.0f;
    @Unique
    public int deathCount = 0;
    @Unique
    private int deathCountResetTimer = 0;
    @Unique
    private class_3218 kanjuWorld;
    @Unique
    private class_2338 kanjuBlockPos = new class_2338(0, 0, 0);
    @Unique
    private class_2338 tempSleepPosition;

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract void method_6033(float var1);

    @Shadow
    public abstract float method_6063();

    @Shadow
    public abstract float method_6032();

    @Shadow
    @Nullable
    protected abstract class_3414 method_6002();

    @Shadow
    @Nullable
    protected abstract class_3414 method_6011(class_1282 var1);

    @Shadow
    @Nullable
    public abstract class_1324 method_5996(class_6880<class_1320> var1);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract Optional<class_2338> method_18398();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void setKanju(class_3218 world, class_2338 blockPos) {
        this.kanjuWorld = world;
        this.kanjuBlockPos = blockPos;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void setMaxHealth(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo ci) {
        class_1324 maxHealthAttributeInstance;
        if (this.maxHealthModifier < 0.0f) {
            this.maxHealthModifier = 0.0f;
        }
        if ((maxHealthAttributeInstance = this.method_5996((class_6880<class_1320>)class_5134.field_23716)) != null) {
            maxHealthAttributeInstance.method_6192((double)Math.abs(this.method_6063() + this.maxHealthModifier));
        }
        if (world instanceof class_3218) {
            this.kanjuWorld = (class_3218)world;
        }
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    public void wakeUpHead(CallbackInfo ci) {
        Optional blockPos = (Optional)this.field_6011.method_12789(class_1309.field_18073);
        blockPos.ifPresent(pos -> {
            this.tempSleepPosition = pos;
        });
    }

    @Inject(method={"wakeUp"}, at={@At(value="TAIL")})
    public void wakeUp(CallbackInfo ci) {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        class_1937 world = this.method_37908();
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        IWorld iWorld = (IWorld)world;
        class_5321<class_1937> dreamWorldKey = iWorld.getDreamWorld();
        class_3218 dreamWorld = server.method_3847(dreamWorldKey);
        if (dreamWorld == null) {
            return;
        }
        class_3218 overworld = server.method_30002();
        if (serverWorld.equals(dreamWorld)) {
            class_2338 spawnPos = overworld.method_43126();
            this.method_48105(server.method_30002(), (double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
            serverWorld.method_65096((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
            return;
        }
        Optional<class_2338> sleepingPosition = Optional.ofNullable(this.tempSleepPosition);
        sleepingPosition.ifPresent(pos -> {
            class_2586 patt0$temp;
            class_3545<Boolean, class_2338> bedHead = DreamPillowItem.getBedHead(serverWorld, pos);
            if (((Boolean)bedHead.method_15442()).booleanValue() && (patt0$temp = this.method_37908().method_8321((class_2338)bedHead.method_15441())) instanceof class_2587) {
                IBedBlockEntity iBedBlockEntity;
                class_2587 bedBlockEntity = (class_2587)patt0$temp;
                if (this.method_37908() == server.method_30002() && (iBedBlockEntity = (IBedBlockEntity)bedBlockEntity).hasDreamPillow()) {
                    this.method_6092(new class_1293(class_1294.field_5924, 100));
                    this.method_48105(dreamWorld, this.method_23317() + 0.5, this.method_23318(), this.method_23321() + 0.5, EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                    class_2338 targetPos = this.findSafeTeleportPos(dreamWorld, new class_2338((int)this.method_23317(), (int)this.method_23318(), (int)this.method_23321()));
                    this.method_48105(dreamWorld, (double)targetPos.method_10263() + 0.5, targetPos.method_10264() + 5, (double)targetPos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                    serverWorld.method_65096((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
                }
            }
        });
    }

    @Unique
    private class_2338 findSafeTeleportPos(class_3218 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13194, pos);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tickBefore(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.method_6059(ModStatusEffects.ELIXIR_OF_LIFE)) {
            if (this.deathCount == 1) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 0));
            }
            if (this.deathCount == 2) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 1));
            }
            if (this.deathCount == 3) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 2));
                this.method_6092(new class_1293(class_1294.field_5901, 20, 0));
            }
            if (this.deathCount == 3) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 3));
                this.method_6092(new class_1293(class_1294.field_5901, 20, 1));
                this.method_6092(new class_1293(class_1294.field_5911, 20, 0));
            }
            if (this.deathCount == 3) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 3));
                this.method_6092(new class_1293(class_1294.field_5901, 20, 2));
                this.method_6092(new class_1293(class_1294.field_5911, 20, 1));
            }
            if (this.deathCount > 3) {
                this.method_6092(new class_1293(class_1294.field_5909, 20, 3));
                this.method_6092(new class_1293(class_1294.field_5901, 20, 2));
                this.method_6092(new class_1293(class_1294.field_5911, 20, 2));
            }
        } else {
            this.deathCount = 0;
        }
        if (!this.method_37908().method_8608()) {
            MinecraftServer server = this.method_37908().method_8503();
            class_1937 world = this.method_37908();
            double mobY = this.method_23318();
            class_5321<class_1937> moonKey = ((IWorld)world).getMoon();
            class_5321 registryKey = world.method_27983();
            if (server != null) {
                class_3218 moonWorld = server.method_3847(moonKey);
                class_3218 endWorld = server.method_3847(class_1937.field_25181);
                if (moonWorld != null && endWorld != null) {
                    if (registryKey.equals(class_1937.field_25181)) {
                        if (mobY >= (double)endWorld.method_31605()) {
                            this.method_48105(moonWorld, this.method_23317(), moonWorld.method_31605() - 1, this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                        }
                    } else if (registryKey.equals(moonKey)) {
                        this.method_6092(new class_1293(class_1294.field_5906, 1, 0));
                        if (mobY >= (double)moonWorld.method_31605()) {
                            this.method_6092(new class_1293(class_1294.field_5906, 800, 0));
                            this.method_48105(endWorld, this.method_23317(), endWorld.method_31605() - 1, this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                        }
                    }
                }
            }
        }
        if (!this.method_37908().method_8608()) {
            ++this.deathCountResetTimer;
            if (this.deathCountResetTimer >= 18000) {
                this.deathCount = Math.max(0, this.deathCount - 1);
                this.deathCountResetTimer = 0;
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    public void damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        boolean isPlayer = (class_1309)this instanceof class_1657;
        boolean deathInElixir = this.deathInElixir(world, source, amount, cir);
        boolean deathInKanju = this.deathInKanju(world, source, amount, cir);
        if (!deathInElixir && !deathInKanju) {
            this.deathByDanmakuEntity(world, source, amount, cir);
            if (this.method_6032() - amount <= 0.0f) {
                IWorld iWorld = (IWorld)world;
                class_5321<class_1937> dreamWorldKey = iWorld.getDreamWorld();
                class_3218 dreamWorld = server.method_3847(dreamWorldKey);
                if (this.method_37908().equals(dreamWorld) && isPlayer) {
                    this.method_6033(this.method_6063());
                    this.field_6017 = 0.0;
                    this.method_48105(server.method_30002(), (double)server.method_30002().method_43126().method_10263() + 0.5, (double)server.method_30002().method_43126().method_10264() + 1.5, (double)server.method_30002().method_43126().method_10260() + 0.5, EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                    return;
                }
                class_1324 maxHealthAttributeInstance = this.method_5996((class_6880<class_1320>)class_5134.field_23716);
                if (maxHealthAttributeInstance != null && this.method_6063() > 20.0f) {
                    maxHealthAttributeInstance.method_6192((double)Math.abs(this.method_6063() - 2.0f));
                }
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")}, cancellable=true)
    public void damageAfter(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_5819 random;
        List<class_1799> armorStacks = List.of(this.method_6118(class_1304.field_6169), this.method_6118(class_1304.field_6174), this.method_6118(class_1304.field_6172), this.method_6118(class_1304.field_6166));
        Stream<class_1792> itemStream = armorStacks.stream().filter(stack -> stack.method_31573(ModTags.ItemTypeTag.DREAM_ARMOR)).map(class_1799::method_7909).filter(item -> item instanceof DreamArmorItem);
        if (!itemStream.toList().isEmpty() && (random = class_5819.method_43047()).method_39332(0, 100) < 39) {
            this.method_6092(new class_1293(class_1294.field_5924, 100));
        }
    }

    @Unique
    public boolean deathByDanmakuEntity(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6032() - amount <= 0.0f && source.method_5526() instanceof DanmakuEntity) {
            LivingEntityMixin self = this;
            self.method_5783(SoundEventInit.BIU, 0.32f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean deathInKanju(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.kanjuWorld == null) {
            return false;
        }
        class_3218 class_32182 = this.kanjuWorld;
        if (class_32182 instanceof class_3218) {
            class_3218 serverWorld = class_32182;
            if (this.method_6059(ModStatusEffects.KANJU_KUSURI) && this.method_6032() - amount <= 0.0f) {
                this.method_6033(1.0f);
                this.method_6033(this.method_6063());
                this.method_48105(serverWorld, this.kanjuBlockPos.method_10263(), this.kanjuBlockPos.method_10264(), this.kanjuBlockPos.method_10260(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                return true;
            }
        }
        return false;
    }

    @Unique
    public boolean deathInElixir(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6059(ModStatusEffects.ELIXIR_OF_LIFE) && this.method_6032() - amount <= 0.0f) {
            ++this.deathCount;
            this.method_6033(1.0f);
            this.method_6033(this.method_6063());
            class_3414 hurtSound = this.method_6011(source);
            class_3414 deathSound = this.method_6002();
            this.method_5783(hurtSound, 1.0f, 1.0f);
            this.method_5783(deathSound, 1.0f, 1.0f);
            this.method_5783(class_3417.field_14931, 1.0f, 1.0f);
            for (class_3222 player : world.method_18456()) {
                world.method_14166(player, (class_2394)class_2398.field_11220, true, false, this.method_23317(), this.method_23318(), this.method_23321(), 250, 1.5, 2.0, 1.5, 0.5);
            }
            cir.cancel();
            return true;
        }
        return false;
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDeath(CallbackInfo ci) {
        if (this.maxHealthModifier >= 1.0f) {
            this.maxHealthModifier -= 1.0f;
        }
        if (this.maxHealthModifier < 0.0f) {
            this.maxHealthModifier = 0.0f;
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="HEAD")})
    public void writeCustomDataToNbt(class_11372 view, CallbackInfo ci) {
        class_5455 registryManager = this.method_56673();
        view.method_71464("MaxHealthModifier", this.maxHealthModifier);
        view.method_71465("DeathCount", this.deathCount);
        view.method_71465("DeathCountResetTimer", this.deathCountResetTimer);
        view.method_71463("ManpozuchiUsingState", this.manpozuchiUsingState);
        view.method_71469("KanjuWorld", this.kanjuWorld.method_27983().method_29177().toString());
        view.method_71466("KanjuBlockPos", this.kanjuBlockPos.method_10063());
    }

    @Inject(method={"readCustomData"}, at={@At(value="HEAD")})
    public void readCustomDataFromNbt(class_11368 view, CallbackInfo ci) {
        class_5455 registryManager = this.method_56673();
        MinecraftServer server = this.method_5682();
        this.maxHealthModifier = view.method_71423("MaxHealthModifier", 0.0f);
        this.deathCount = view.method_71424("DeathCount", 0);
        this.deathCountResetTimer = view.method_71424("DeathCountResetTimer", 0);
        this.manpozuchiUsingState = view.method_71422("ManpozuchiUsingState", 0.0);
        String kanjuWorldStr = view.method_71428("KanjuWorld", "");
        if (kanjuWorldStr != null && !kanjuWorldStr.isEmpty() && server != null) {
            this.kanjuWorld = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)kanjuWorldStr)));
        }
        this.kanjuBlockPos = class_2338.method_10092((long)view.method_71425("KanjuBlockPos", new class_2338(0, 0, 0).method_10063()));
    }

    @Override
    public void setDeathCount(int deathCount) {
        this.deathCount = deathCount;
    }

    @Override
    public int getDeathCount() {
        return this.deathCount;
    }

    @Override
    public void setMaxHealthModifier(float value) {
        this.maxHealthModifier = value;
    }

    @Override
    public float getMaxHealthModifier() {
        return this.maxHealthModifier;
    }

    @Override
    public void setManpozuchiUsingState(double value) {
        this.manpozuchiUsingState = value;
    }

    @Override
    public double getManpozuchiUsingState() {
        return this.manpozuchiUsingState;
    }
}

