/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe.type;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.danmaku.SpellCardTemplates;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.item.danmaku.DanmakuItem;
import cc.thonly.reverie_dreams.item.template.SpellCardTemplateItem;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.StrengthTableRecipe;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrengthTableRecipeType
extends BaseRecipeType<StrengthTableRecipe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StrengthTableRecipeType.class);
    private static StrengthTableRecipeType INSTANCE;
    private final Map<String, Integer> automaticRecipeIdCounter = new Object2ObjectOpenHashMap();
    private final LinkedHashMap<class_2960, StrengthTableRecipe> dynamicBuilder = new LinkedHashMap();
    private static final float MAX_SPEED = 2.5f;
    private static final int MAX_COUNT = 3;
    private static final float MAX_DAMAGE = 5.5f;

    public StrengthTableRecipeType() {
        INSTANCE = this;
    }

    public static synchronized StrengthTableRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        this.dynamicBuilder.clear();
        this.automaticRecipeIdCounter.clear();
        Map resources = manager.method_14488(this.getTypeId() + "_recipe", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id2 = (class_2960)entry.getKey();
            class_2960 registryKey = class_2960.method_60655((String)id2.method_12836(), (String)id2.method_12832().replaceFirst("^strength_table_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    DataResult result = this.getCodec().parse(input);
                    result.resultOrPartial(error -> log.error("Failed to load strength table recipe {}, {}", (Object)id2, error)).ifPresent(recipe -> this.add(registryKey, recipe));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e2) {
                log.error("Failed to load strength table recipe {}, {}, {}", new Object[]{id2, e2.getMessage(), e2});
            }
        }
        List<class_1792> danmakuItemView = RegistryManager.DANMAKU_TYPE.values().stream().map(DanmakuType::getItem).toList();
        List<class_1799> danmakuItemStackView = danmakuItemView.stream().map(class_1792::method_7854).toList();
        List<class_1799> templateStackView = SpellCardTemplates.getRegistryItemStackView().values().stream().map(class_1799::method_7972).toList();
        this.registerAutomaticDynamic(danmakuItemStackView, templateStackView, ModDataComponentTypes.Danmaku.TEMPLATE);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(ModItems.SPEED_FEATHER.method_7854()), ModDataComponentTypes.Danmaku.SPEED);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(class_1802.field_8828.method_7854()), ModDataComponentTypes.Danmaku.COUNT);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(class_1802.field_8371.method_7854()), ModDataComponentTypes.Danmaku.DAMAGE);
        Map sortedByKey = this.dynamicBuilder.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(LinkedHashMap::new, (m, e) -> m.put((class_2960)e.getKey(), (StrengthTableRecipe)e.getValue()), Map::putAll);
        sortedByKey.forEach(this::add);
    }

    private void registerAutomaticDynamic(List<class_1799> main, List<class_1799> off, class_9331 componentType) {
        class_1799[] mainItems = main.toArray(new class_1799[0]);
        class_1799[] offItems = off.toArray(new class_1799[0]);
        for (class_1799 mainItem : mainItems) {
            for (class_1799 offItem : offItems) {
                String value = null;
                try {
                    String mainItemIdStr = class_7923.field_41178.method_10221((Object)mainItem.method_7909()).method_12832();
                    String offItemIdStr = class_7923.field_41178.method_10221((Object)offItem.method_7909()).method_12832();
                    String builder = mainItemIdStr + offItemIdStr;
                    Integer num = this.automaticRecipeIdCounter.computeIfAbsent(builder, x -> 0);
                    String builderByCounter = builder + "_" + num;
                    num = num + 1;
                    this.automaticRecipeIdCounter.put(builder, num);
                    class_1799 outputStack = mainItem.method_7972();
                    Object object = offItem.method_58694(componentType);
                    if (object != null) {
                        outputStack.method_57379(componentType, object);
                    }
                    value = builderByCounter;
                    StrengthTableRecipe strengthTableRecipe = new StrengthTableRecipe(ItemStackWrapper.of(mainItem), ItemStackWrapper.of(offItem), ItemStackWrapper.of(outputStack));
                    strengthTableRecipe.setVirtual(true);
                    this.dynamicBuilder.put(class_2960.method_60654((String)builderByCounter.toLowerCase()), strengthTableRecipe);
                }
                catch (Exception e) {
                    log.error("Can't register dynamic recipe, id: {} , {}", value, (Object)e);
                }
            }
        }
    }

    @Override
    public void bootstrap() {
    }

    @Override
    public List<StrengthTableRecipe> getMatches(List<ItemStackWrapper> wrappers) {
        ItemStackWrapper off;
        if (wrappers.size() < 2) {
            return List.of();
        }
        ArrayList<StrengthTableRecipe> recipe = new ArrayList<StrengthTableRecipe>();
        ItemStackWrapper main = wrappers.get(0);
        ItemStackWrapper output = this.tryGetOutput(main, off = wrappers.get(1));
        if (output != null) {
            ItemStackWrapper mainClone = main.clone();
            ItemStackWrapper offClone = off.clone();
            ItemStackWrapper outputClone = output.clone();
            mainClone.getItemStack().method_7939(1);
            offClone.getItemStack().method_7939(1);
            recipe.add(new StrengthTableRecipe(mainClone, offClone, outputClone));
        }
        return recipe;
    }

    public ItemStackWrapper tryGetOutput(ItemStackWrapper main, ItemStackWrapper off) {
        float damage;
        int count;
        int sum;
        float speed;
        float sum2;
        String templateId;
        boolean isIronSword;
        class_1799 mainStack = main.getItemStack().method_7972();
        class_1799 offStack = off.getItemStack().method_7972();
        class_1792 mainItem = mainStack.method_7909();
        class_1792 offItem = offStack.method_7909();
        boolean isDanmakuItem = mainItem instanceof DanmakuItem;
        boolean isSpellCardTemplate = offItem instanceof SpellCardTemplateItem;
        boolean isSpeedItem = offItem == ModItems.SPEED_FEATHER;
        boolean isSlime = offItem == class_1802.field_8828;
        boolean bl = isIronSword = offItem == class_1802.field_8371;
        if (isDanmakuItem && isSpellCardTemplate && (templateId = (String)offStack.method_58694(ModDataComponentTypes.Danmaku.TEMPLATE)) != null) {
            mainStack.method_57379(ModDataComponentTypes.Danmaku.TEMPLATE, (Object)templateId);
            return new ItemStackWrapper(mainStack);
        }
        if (isDanmakuItem && isSpeedItem && (sum2 = (speed = ((Float)mainStack.method_58695(ModDataComponentTypes.Danmaku.SPEED, (Object)Float.valueOf(1.0f))).floatValue()) + 0.25f) <= 2.5f) {
            mainStack.method_57379(ModDataComponentTypes.Danmaku.SPEED, (Object)Float.valueOf(sum2));
            return new ItemStackWrapper(mainStack);
        }
        if (isDanmakuItem && isSlime && (sum = (count = ((Integer)mainStack.method_58695(ModDataComponentTypes.Danmaku.COUNT, (Object)1)).intValue()) + 1) < 3) {
            mainStack.method_57379(ModDataComponentTypes.Danmaku.COUNT, (Object)sum);
            return new ItemStackWrapper(mainStack);
        }
        if (isDanmakuItem && isIronSword && (sum2 = (damage = ((Float)mainStack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE, (Object)Float.valueOf(2.0f))).floatValue()) + 0.25f) < 5.5f) {
            mainStack.method_57379(ModDataComponentTypes.Danmaku.DAMAGE, (Object)Float.valueOf(sum2));
            return new ItemStackWrapper(mainStack);
        }
        return null;
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<StrengthTableRecipe> getCodec() {
        return StrengthTableRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "strength_table";
    }

    @Override
    public class_2960 getId() {
        return Touhou.id(this.getTypeId());
    }
}

