/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.registry;

import cc.thonly.registry_modifier.mixin.NamedAccessor;
import cc.thonly.reverie_dreams.registry.BuiltinObject;
import cc.thonly.reverie_dreams.registry.Initialization;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import cc.thonly.reverie_dreams.registry.ReloadStep;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraft.class_9248;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntrinsicalRegister<T>
implements class_2385<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntrinsicalRegister.class);
    private final class_5321<? extends class_2378<T>> key;
    private final Map<class_2960, class_6880.class_6883<T>> idToEntry;
    private final Map<class_5321<T>, class_6880.class_6883<T>> keyToEntry;
    private final HashBiMap<Integer, class_6880.class_6883<T>> rawIdToEntry;
    private final Map<T, class_6880.class_6883<T>> valueToEntry;
    private final Map<class_5321<T>, class_9248> keyToEntryInfo;
    private final List<Initialization<T>> builders = new LinkedList<Initialization<T>>();
    private final List<ReloadStep<T>> reloadableSteps = new LinkedList<ReloadStep<T>>();
    private final Map<class_2960, T> builtins = new Object2ObjectLinkedOpenHashMap();
    private final Map<class_6862<T>, class_6885.class_6888<T>> tags = new Object2ObjectLinkedOpenHashMap();
    private final Lifecycle lifecycle;
    private class_2960 defaultId;
    private boolean frozen = false;
    private boolean reloadable = false;
    private Codec<T> codec;
    @Nullable
    private IntrinsicalRegister<T> parent;

    public IntrinsicalRegister(class_5321<? extends class_2378<T>> key) {
        this(key, Lifecycle.stable());
    }

    public IntrinsicalRegister(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle) {
        this.key = key;
        this.lifecycle = lifecycle;
        this.idToEntry = new Object2ObjectLinkedOpenHashMap();
        this.keyToEntry = new Object2ObjectLinkedOpenHashMap();
        this.rawIdToEntry = HashBiMap.create();
        this.valueToEntry = new Object2ObjectLinkedOpenHashMap();
        this.keyToEntryInfo = new Object2ObjectLinkedOpenHashMap();
    }

    public IntrinsicalRegister(class_5321<? extends class_2378<T>> key, @Nullable IntrinsicalRegister<T> parent) {
        this(key, Lifecycle.stable(), parent);
    }

    public IntrinsicalRegister(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle, @Nullable IntrinsicalRegister<T> parent) {
        this(key, lifecycle);
        this.parent = parent;
    }

    public void validate() {
        AtomicInteger next = new AtomicInteger();
        this.keyToEntry.forEach((registryKey, reference) -> {
            if (registryKey == null) {
                log.error("Can't verify registry key, rawId: {}", (Object)next.get());
                return;
            }
            if (reference == null) {
                log.error("Can't verify registry entry reference, registryKey: {}", registryKey);
                return;
            }
            if (reference.comp_349() == null) {
                log.error("Can't verify registry entry value, registryKey: {}", registryKey);
                return;
            }
            next.getAndIncrement();
        });
    }

    public IntrinsicalRegister<T> shadow() {
        return new IntrinsicalRegister<T>(this.key, this);
    }

    public Set<Map.Entry<class_2960, T>> entrySet() {
        return this.method_29722().stream().collect(Collectors.toMap(entry -> ((class_5321)entry.getKey()).method_29177(), Map.Entry::getValue)).entrySet();
    }

    public IntrinsicalRegister<T> build() {
        if (this.frozen) {
            return this;
        }
        this.builders.forEach(step -> step.bootstrap(this));
        this.method_40276();
        return this;
    }

    public IntrinsicalRegister<T> builder(Initialization<T> ... initializations) {
        this.builders.addAll(Arrays.asList(initializations));
        return this;
    }

    public IntrinsicalRegister<T> reloadBuilder(ReloadStep<T> ... steps) {
        this.reloadableSteps.addAll(Arrays.asList(steps));
        this.reloadable = true;
        return this;
    }

    public IntrinsicalRegister<T> codec(Codec<T> codec) {
        this.codec = codec;
        return this;
    }

    public IntrinsicalRegister<T> defaultId(class_2960 defaultId) {
        this.defaultId = defaultId;
        return this;
    }

    public void clear() {
        this.idToEntry.clear();
        this.keyToEntry.clear();
        this.rawIdToEntry.clear();
        this.valueToEntry.clear();
        this.keyToEntryInfo.clear();
    }

    public void reload(class_3300 manager) {
        this.idToEntry.clear();
        this.keyToEntry.clear();
        this.rawIdToEntry.clear();
        this.valueToEntry.clear();
        this.keyToEntryInfo.clear();
        for (Map.Entry<class_2960, T> entry : this.builtins.entrySet()) {
            class_2960 key = entry.getKey();
            T value = entry.getValue();
            this.method_10272(class_5321.method_29179(this.key, (class_2960)key), value, class_9248.field_49136);
        }
        for (ReloadStep reloadStep : this.reloadableSteps) {
            reloadStep.reload(manager);
        }
    }

    public Stream<Map.Entry<class_2960, T>> streamIdToValue() {
        return this.idToEntry.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((class_6880.class_6883)entry.getValue()).comp_349())).entrySet().stream();
    }

    public Map<Integer, class_6880.class_6883<T>> getIdToEntryMap() {
        return Map.copyOf(this.rawIdToEntry);
    }

    public Set<class_2960> keys() {
        return new LinkedHashSet<class_2960>(this.idToEntry.keySet());
    }

    public Set<T> values() {
        return new LinkedHashSet<T>(this.valueToEntry.keySet());
    }

    public void setBuiltin(class_2960 id, T value) {
        if (this.builtins.containsKey(id) || this.builtins.containsValue(value)) {
            return;
        }
        this.builtins.put(id, value);
    }

    public class_6880.class_6883<T> method_10272(class_5321<T> key, T value, class_9248 info) {
        class_2960 id = key.method_29177();
        class_6880.class_6883<T> entry = this.method_40269(value);
        entry.method_45917(key);
        this.idToEntry.put(id, entry);
        this.keyToEntry.put(key, entry);
        this.rawIdToEntry.put((Object)(this.idToEntry.size() - 1), entry);
        this.valueToEntry.put(value, entry);
        this.keyToEntryInfo.put(key, info);
        if (value instanceof BuiltinObject) {
            this.builtins.put(id, value);
        }
        if (value instanceof OwnerBinding) {
            OwnerBinding ownerBinding = (OwnerBinding)value;
            ownerBinding.setOwner(this);
        }
        return entry;
    }

    public class_6880.class_6883<T> set(class_5321<T> key, T value, class_9248 info) {
        if (!this.keyToEntry.containsKey(key)) {
            return this.method_10272(key, value, info);
        }
        class_2960 id = key.method_29177();
        Optional<class_6880.class_6883<T>> oldEntry = this.method_10223(id);
        if (oldEntry.isEmpty()) {
            log.error("Can't find prev value in registry {}", this.key);
            Optional<class_6880.class_6883<Object>> defaultEntry = this.method_60385();
            return defaultEntry.orElse(null);
        }
        this.builtins.remove(id);
        int oldRawId = (Integer)this.rawIdToEntry.inverse().get(oldEntry.get());
        this.rawIdToEntry.remove((Object)oldRawId);
        class_6880.class_6883<T> entry = this.method_40269(value);
        entry.method_45917(key);
        this.idToEntry.put(id, entry);
        this.keyToEntry.put(key, entry);
        this.rawIdToEntry.put((Object)oldRawId, entry);
        this.valueToEntry.put(value, entry);
        this.keyToEntryInfo.put(key, info);
        if (value instanceof BuiltinObject) {
            this.builtins.put(id, value);
        }
        return entry;
    }

    public void method_62681(class_6862<T> tag, List<class_6880<T>> registryEntries) {
        class_6885.class_6888 entryListNamed = NamedAccessor.callNew((class_7876)this, tag);
        this.tags.put(tag, entryListNamed);
        entryListNamed.field_36460 = new ArrayList<class_6880<T>>(registryEntries);
    }

    public boolean method_35863() {
        return this.keyToEntry.isEmpty();
    }

    public class_7871<T> method_46769() {
        return new class_7871<T>(){

            public Optional<class_6880.class_6883<T>> method_46746(class_5321<T> key) {
                return Optional.of(this.method_46747(key));
            }

            public class_6880.class_6883<T> method_46747(class_5321<T> key) {
                return IntrinsicalRegister.this.getOrCreateEntry(key);
            }

            public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> tag) {
                return Optional.of(this.method_46735(tag));
            }

            public class_6885.class_6888<T> method_46735(class_6862<T> tag) {
                return IntrinsicalRegister.this.getTag(tag);
            }
        };
    }

    public class_5321<? extends class_2378<T>> method_46765() {
        return this.key;
    }

    public Lifecycle method_46766() {
        return this.lifecycle;
    }

    @Nullable
    public class_2960 method_10221(T value) {
        for (Map.Entry<class_2960, class_6880.class_6883<T>> mapEntry : this.idToEntry.entrySet()) {
            if (!mapEntry.getValue().comp_349().equals(value)) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    public Optional<class_5321<T>> method_29113(T value) {
        class_6880.class_6883<T> ref = this.valueToEntry.get(value);
        return ref != null && ref.method_40227() ? Optional.of(ref.method_40237()) : Optional.empty();
    }

    public int method_10206(@Nullable T value) {
        Optional<class_6880.class_6883<T>> entry = this.method_10223(this.method_10221(value));
        if (entry.isEmpty()) {
            return -1;
        }
        return (Integer)this.rawIdToEntry.inverse().get(entry.get());
    }

    @Nullable
    public T method_10200(int index) {
        class_6880.class_6883 tReference = (class_6880.class_6883)this.rawIdToEntry.get((Object)index);
        if (tReference == null) {
            return null;
        }
        return (T)tReference.comp_349();
    }

    public int method_10204() {
        return this.keyToEntry.size();
    }

    @Nullable
    public T method_29107(@Nullable class_5321<T> key) {
        class_6880.class_6883<T> entry = this.keyToEntry.get(key);
        if (entry == null) {
            class_6880.class_6883 tReference = this.method_60385().orElse(null);
            if (tReference == null) {
                return null;
            }
            return (T)tReference.comp_349();
        }
        return (T)entry.comp_349();
    }

    @Nullable
    public T method_63535(@Nullable class_2960 id) {
        if (id == null) {
            return this.method_60385().map(class_6880::comp_349).orElse(null);
        }
        class_6880.class_6883<T> ref = this.idToEntry.get(id);
        if (ref != null) {
            return (T)ref.comp_349();
        }
        return this.method_60385().map(class_6880::comp_349).orElse(null);
    }

    public Optional<class_9248> method_57058(class_5321<T> key) {
        return Optional.ofNullable(this.keyToEntryInfo.get(key));
    }

    public Optional<class_6880.class_6883<T>> method_60385() {
        return this.method_10223(this.defaultId);
    }

    public Set<class_2960> method_10235() {
        return Set.copyOf(this.idToEntry.keySet());
    }

    public Set<Map.Entry<class_5321<T>, T>> method_29722() {
        return Collections.unmodifiableSet(class_156.method_65967(this.keyToEntry, class_6880::comp_349).entrySet());
    }

    public Set<class_5321<T>> method_42021() {
        return Set.copyOf(this.keyToEntry.keySet());
    }

    public Optional<class_6880.class_6883<T>> method_10240(class_5819 random) {
        return class_156.method_40083(this.idToEntry.values().stream().toList(), (class_5819)random);
    }

    public boolean method_10250(class_2960 id) {
        return this.idToEntry.containsKey(id);
    }

    public boolean method_35842(class_5321<T> key) {
        return this.keyToEntry.containsKey(key);
    }

    public class_2378<T> method_40276() {
        this.frozen = true;
        return this;
    }

    public class_2378<T> unfreeze() {
        this.frozen = false;
        return this;
    }

    public class_6880.class_6883<T> method_40269(T value) {
        return class_6880.class_6883.method_40233((class_7876)this, value);
    }

    class_6880.class_6883<T> getOrCreateEntry(class_5321<T> key) {
        return this.keyToEntry.computeIfAbsent(key, key2 -> class_6880.class_6883.method_40234((class_7876)this, (class_5321)key2));
    }

    class_6885.class_6888<T> getTag(class_6862<T> key) {
        return this.tags.computeIfAbsent(key, this::createNamedEntryList);
    }

    private class_6885.class_6888<T> createNamedEntryList(class_6862<T> tag) {
        return NamedAccessor.callNew((class_7876)this, tag);
    }

    public Optional<class_6880.class_6883<T>> method_40265(int rawId) {
        return Optional.ofNullable((class_6880.class_6883)this.rawIdToEntry.get((Object)rawId));
    }

    public Optional<class_6880.class_6883<T>> method_10223(class_2960 id) {
        return Optional.ofNullable(this.idToEntry.get(id));
    }

    public class_6880<T> method_47983(T value) {
        class_6880 reference = this.valueToEntry.get(value);
        return reference != null ? reference : class_6880.method_40223(value);
    }

    public Stream<class_6885.class_6888<T>> method_40272() {
        return Stream.empty();
    }

    public class_2378.class_10106<T> method_62683(class_3503.class_6863<T> tags) {
        return null;
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.keyToEntry.values().stream().map(class_6880::comp_349).iterator();
    }

    public Stream<class_6880.class_6883<T>> method_42017() {
        return this.keyToEntry.values().stream();
    }

    public Stream<class_6885.class_6888<T>> method_42020() {
        return this.tags.values().stream();
    }

    public Optional<class_6880.class_6883<T>> method_46746(class_5321<T> key) {
        return this.method_10223(key.method_29177());
    }

    public Optional<class_6885.class_6888<T>> method_46733(class_6862<T> tag) {
        return Optional.ofNullable(this.tags.get(tag));
    }

    @Generated
    public boolean isReloadable() {
        return this.reloadable;
    }

    @Generated
    public Codec<T> method_39673() {
        return this.codec;
    }

    @Nullable
    @Generated
    public IntrinsicalRegister<T> getParent() {
        return this.parent;
    }
}

