/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util;

import cc.thonly.reverie_dreams.Touhou;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class ImageToTextScanner {
    private static final Map<Class<?>, ImageToTextScanner> INSTANCES = new Object2ObjectOpenHashMap();
    public static final LoaderFactory DEFAULT_FACTORY = instance -> {
        instance.loadImageFromJar(ImageToTextScanner.ofNamespace("reverie_dreams", "icon.png"));
        instance.loadImageFromJar(ImageToTextScanner.ofNamespace("reverie_dreams", "icon_about.png"));
    };
    private final Map<Integer, List<class_2561>> caches = new HashMap<Integer, List<class_2561>>();
    private final Class<?> clazz;

    private ImageToTextScanner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static ImageToTextScanner createInstance(Class<?> clazz) {
        return INSTANCES.computeIfAbsent(clazz, x -> new ImageToTextScanner(clazz));
    }

    public static void bootstrap() {
        CompletableFuture.runAsync(() -> {
            ImageToTextScanner instance = ImageToTextScanner.createInstance(Touhou.class);
            DEFAULT_FACTORY.onLoad(instance);
        });
    }

    public static String ofNamespace(String namespace, String filename) {
        return "/assets/" + namespace + "/" + filename;
    }

    public List<class_2561> renderImageToText(BufferedImage image, int width, int height) {
        int key = Objects.hash(width, height, this.imageHash(image));
        if (this.caches.containsKey(key)) {
            return this.caches.get(key);
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (int y = 0; y < Math.min(height, image.getHeight()); ++y) {
            class_5250 line = class_2561.method_43470((String)"");
            for (int x = 0; x < Math.min(width, image.getWidth()); ++x) {
                int argb = image.getRGB(x, y);
                int alpha = argb >> 24 & 0xFF;
                if (alpha < 128) {
                    line.method_10852((class_2561)class_2561.method_43470((String)" ").method_10862(class_2583.field_24360.method_10977(class_124.field_1074)));
                    continue;
                }
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                line.method_10852((class_2561)class_2561.method_43470((String)"\u2588").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)(red << 16 | green << 8 | blue)))));
            }
            lines.add((class_2561)line);
        }
        this.caches.put(key, lines);
        return lines;
    }

    public BufferedImage loadImageFromJar(String pathInJar) {
        BufferedImage bufferedImage;
        block9: {
            InputStream stream = this.clazz.getResourceAsStream(pathInJar);
            try {
                if (stream == null) {
                    throw new IllegalArgumentException("Resource not found in JAR: " + pathInJar);
                }
                bufferedImage = ImageIO.read(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load image from JAR: " + pathInJar, e);
                }
            }
            stream.close();
        }
        return bufferedImage;
    }

    private int imageHash(BufferedImage image) {
        int hash = 7;
        for (int y = 0; y < image.getHeight(); y += 4) {
            for (int x = 0; x < image.getWidth(); x += 4) {
                hash = 31 * hash + image.getRGB(x, y);
            }
        }
        return hash;
    }

    public void clearCache() {
        this.caches.clear();
    }

    @FunctionalInterface
    public static interface LoaderFactory {
        public void onLoad(ImageToTextScanner var1);
    }
}

