/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class NetUtil {
    private static final OkHttpClient client = new OkHttpClient();
    private static final Gson gson = new Gson();

    public static boolean isUrlAccessible(String url) {
        boolean bl;
        block8: {
            Request request = new Request.Builder().url(url).head().build();
            Response response = client.newCall(request).execute();
            try {
                bl = response.isSuccessful();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public static void downloadFile(String url, File destFile) throws IOException {
        Request request = new Request.Builder().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + String.valueOf(response));
            }
            ResponseBody body = response.body();
            if (body == null) {
                throw new IOException("Response body is null");
            }
            try (InputStream in = body.byteStream();
                 FileOutputStream out = new FileOutputStream(destFile);){
                int len;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
        }
    }

    public static boolean isChinaNetwork() {
        try {
            Request req = new Request.Builder().url("http://ip-api.com/json/").build();
            Response resp = client.newCall(req).execute();
            String body = resp.body().string();
            JsonObject object = (JsonObject)gson.fromJson(body, JsonObject.class);
            String code = object.get("countryCode").getAsString();
            resp.close();
            return code.equals("CN") || code.equals("HK") || code.equals("MO") || code.equals("TW");
        }
        catch (Exception e) {
            return false;
        }
    }
}

