/*
 * Decompiled with CFR 0.152.
 */
package nota.model;

import java.io.File;
import java.util.HashMap;
import nota.model.CustomInstrument;
import nota.model.Layer;

public class Song
implements Cloneable {
    HashMap<Integer, Layer> layerHashMap;
    short songHeight;
    short length;
    String title;
    File path;
    String author;
    String originalAuthor;
    String description;
    float speed;
    float delay;
    CustomInstrument[] customInstruments;
    int firstCustomInstrumentIndex;
    boolean isStereo;

    public Song(Song other) {
        this(other.getSpeed(), other.getLayerHashMap(), other.getSongHeight(), other.getLength(), other.getTitle(), other.getAuthor(), other.getOriginalAuthor(), other.getDescription(), other.getPath(), other.getFirstCustomInstrumentIndex(), other.getCustomInstruments(), other.isStereo);
    }

    public Song(float speed, HashMap<Integer, Layer> layerHashMap, short songHeight, short length, String title, String author, String originalAuthor, String description, File path, int firstCustomInstrumentIndex, boolean isStereo) {
        this(speed, layerHashMap, songHeight, length, title, author, originalAuthor, description, path, firstCustomInstrumentIndex, new CustomInstrument[0], isStereo);
    }

    public Song(float speed, HashMap<Integer, Layer> layerHashMap, short songHeight, short length, String title, String author, String originalAuthor, String description, File path, int firstCustomInstrumentIndex, CustomInstrument[] customInstruments, boolean isStereo) {
        this.speed = speed;
        this.delay = 20.0f / speed;
        this.layerHashMap = layerHashMap;
        this.songHeight = songHeight;
        this.length = length;
        this.title = title;
        this.author = author;
        this.originalAuthor = originalAuthor;
        this.description = description;
        this.path = path;
        this.firstCustomInstrumentIndex = firstCustomInstrumentIndex;
        this.customInstruments = customInstruments;
        this.isStereo = isStereo;
    }

    public HashMap<Integer, Layer> getLayerHashMap() {
        return this.layerHashMap;
    }

    public short getSongHeight() {
        return this.songHeight;
    }

    public short getLength() {
        return this.length;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public File getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getDelay() {
        return this.delay;
    }

    public CustomInstrument[] getCustomInstruments() {
        return this.customInstruments;
    }

    public Song clone() {
        return new Song(this);
    }

    public int getFirstCustomInstrumentIndex() {
        return this.firstCustomInstrumentIndex;
    }

    public boolean isStereo() {
        return this.isStereo;
    }
}

