/*
 * Decompiled with CFR 0.152.
 */
package nota.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2766;
import net.minecraft.class_3414;
import nota.model.CustomInstrument;
import nota.model.Layer;
import nota.model.Note;
import nota.model.Song;
import nota.utils.NBSDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBSDecoderPlus
extends NBSDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NBSDecoderPlus.class);
    private static final Map<class_2766, Byte> instrumentToByteMap = new HashMap<class_2766, Byte>();

    public static Song parse(File songFile, class_2766 instrument) {
        try {
            Song song = NBSDecoderPlus.parse(new FileInputStream(songFile), songFile);
            if (song == null) {
                log.error("Failed to parse NBS file: {}", (Object)songFile.getName());
                return null;
            }
            CustomInstrument[] customInstruments = song.getCustomInstruments();
            for (int i = 0; i < customInstruments.length; ++i) {
                customInstruments[i].setSound((class_3414)instrument.method_11886().comp_349());
            }
            HashMap<Integer, Layer> layerHashMap = song.getLayerHashMap();
            for (Map.Entry<Integer, Layer> entry : layerHashMap.entrySet()) {
                Layer layer = entry.getValue();
                for (Map.Entry<Integer, Note> lay : layer.getNotesAtTicks().entrySet()) {
                    Note note = lay.getValue();
                    note.setInstrument(NBSDecoderPlus.getByteFromInstrument(instrument));
                }
            }
            return song;
        }
        catch (FileNotFoundException e) {
            log.error("Failed to parse NBS File: ", (Throwable)e);
            return null;
        }
    }

    public static byte getByteFromInstrument(class_2766 instrument) {
        return instrumentToByteMap.getOrDefault(instrument, (byte)0);
    }

    static {
        instrumentToByteMap.put(class_2766.field_12648, (byte)0);
        instrumentToByteMap.put(class_2766.field_12651, (byte)1);
        instrumentToByteMap.put(class_2766.field_12653, (byte)2);
        instrumentToByteMap.put(class_2766.field_12643, (byte)3);
        instrumentToByteMap.put(class_2766.field_12645, (byte)4);
        instrumentToByteMap.put(class_2766.field_12654, (byte)5);
        instrumentToByteMap.put(class_2766.field_12650, (byte)6);
        instrumentToByteMap.put(class_2766.field_12644, (byte)7);
        instrumentToByteMap.put(class_2766.field_12647, (byte)8);
        instrumentToByteMap.put(class_2766.field_12655, (byte)9);
        instrumentToByteMap.put(class_2766.field_18284, (byte)10);
        instrumentToByteMap.put(class_2766.field_18285, (byte)11);
        instrumentToByteMap.put(class_2766.field_18286, (byte)12);
        instrumentToByteMap.put(class_2766.field_18287, (byte)13);
        instrumentToByteMap.put(class_2766.field_18288, (byte)14);
        instrumentToByteMap.put(class_2766.field_18289, (byte)15);
    }
}

