/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polymer;

import cc.thonly.polymer.entity.BaguaFurnaceImpl;
import cc.thonly.polymer.entity.DanmakuImpl;
import cc.thonly.polymer.entity.HairballImpl;
import cc.thonly.polymer.entity.KillerBeeImpl;
import cc.thonly.polymer.entity.MagicBroomImpl;
import cc.thonly.polymer.entity.MaidYouseiImpl;
import cc.thonly.polymer.entity.MoonRabbitImpl;
import cc.thonly.polymer.entity.MushroomMonsterImpl;
import cc.thonly.polymer.entity.NPCImpl;
import cc.thonly.polymer.entity.OreEspImpl;
import cc.thonly.polymer.entity.PolymerHolderEntity;
import cc.thonly.polymer.entity.RoleImpl;
import cc.thonly.polymer.entity.ScarecrowImpl;
import cc.thonly.polymer.entity.SunflowerYouseiImpl;
import cc.thonly.polymer.entity.TickHolderEntity;
import cc.thonly.polymer.entity.UfoImpl;
import cc.thonly.polymer.entity.VillagerImpl;
import cc.thonly.polymer.entity.WheelChairImpl;
import cc.thonly.polymer.entity.WildPigImpl;
import cc.thonly.polymer.entity.YouseiImpl;
import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.npc.NPCRole;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.util.entity.ModelUtil;
import de.tomalbrc.bil.core.model.Model;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;

public class PolymerEntityHelper {
    public static final Map<class_1299<? extends class_1297>, Function<? extends class_1297, PolymerEntity>> ENTITY_TYPE_FUNCTION_MAP = new HashMap<class_1299<? extends class_1297>, Function<? extends class_1297, PolymerEntity>>();
    public static final WeakHashMap<class_1297, ItemDisplayElement> POLYMER_PLAYER_ELEMENTS = new WeakHashMap();
    public static final List<PolymerHolderEntity> HOLD_RENDER_QUEUE = new LinkedList<PolymerHolderEntity>();
    public static final Model YOUSEI_WING_MODEL = ModelUtil.loadBBModel(ReverieDreams.id("yousei_wing"));
    public static final Model HAIRBALL_MODEL = ModelUtil.loadBBModel(ReverieDreams.id("hairball"));
    public static final Model MUSHROOM_MONSTER_MODEL = ModelUtil.loadBBModel(ReverieDreams.id("mushroom_monster"));
    public static final Model UFO_MODEL = ModelUtil.loadBBModel(ReverieDreams.id("ufo"));
    public static final Model SCARECROW_MODEL = ModelUtil.loadBBModel(ReverieDreams.id("scarecrow"));

    public static void bootstrap() {
        PolymerEntityHelper.registerOverlay(RDEntityTypes.SUNFLOWER_YOUSEI, SunflowerYouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.YOUSEI, YouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MAID_YOUSEI, MaidYouseiImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.GHOST, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.GOBLIN, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WATER_ELEMENTAL, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.FIRE_ELEMENTAL, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.ICE_ELEMENTAL, NPCImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MAGIC_BROOM, MagicBroomImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WHEEL_CHAIR, WheelChairImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MOON_RABBIT, MoonRabbitImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.KILLER_BEE, KillerBeeImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.ORE_ESP, OreEspImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.BAGUA_FURNACE, BaguaFurnaceImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.DANMAKU, DanmakuImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.KNIFE, DanmakuImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.FUMO_SELLER_VILLAGER, VillagerImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.NPC_ROLE, RoleImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.HAIRBALL, HairballImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.MUSHROOM_MONSTER, MushroomMonsterImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.WILD_PIG, WildPigImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.TAVERN_VILLAGER, VillagerImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.SCARECROW, ScarecrowImpl::new);
        PolymerEntityHelper.registerOverlay(RDEntityTypes.UFO, UfoImpl::new);
        Iterator<NPCRole> iterator = RegistryHandlers.NPC_ROLE.iterator();
        while (iterator.hasNext()) {
            NPCRole role = iterator.next();
            PolymerEntityHelper.registerOverlay(role.getEntityType(), npcRoleFastEntity -> context -> class_1299.field_42460);
        }
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (HOLD_RENDER_QUEUE.isEmpty()) {
                return;
            }
            Iterator<PolymerHolderEntity> iterator = HOLD_RENDER_QUEUE.iterator();
            while (iterator.hasNext()) {
                PolymerHolderEntity next = iterator.next();
                next.onCreated();
                iterator.remove();
            }
            TickHolderEntity.tick();
        });
    }

    public static void addEntityHolderModel(PolymerHolderEntity polymerHolderEntity) {
        HOLD_RENDER_QUEUE.add(polymerHolderEntity);
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerOverlay(type, constructor);
        ENTITY_TYPE_FUNCTION_MAP.put(type, constructor);
    }
}

